/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class ConstantPool
implements Cloneable,
Node {
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
    }

    public ConstantPool(DataInput input2) throws IOException, ClassFormatException {
        int constant_pool_count = input2.readUnsignedShort();
        this.constant_pool = new Constant[constant_pool_count];
        for (int i = 1; i < constant_pool_count; ++i) {
            this.constant_pool[i] = Constant.readConstant(input2);
            byte tag = this.constant_pool[i].getTag();
            if (tag != 6 && tag != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantPool(this);
    }

    public String constantToString(Constant c) throws ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = String.valueOf(((ConstantDouble)c).getBytes());
                break;
            }
            case 4: {
                str = String.valueOf(((ConstantFloat)c).getBytes());
                break;
            }
            case 5: {
                str = String.valueOf(((ConstantLong)c).getBytes());
                break;
            }
            case 3: {
                str = String.valueOf(((ConstantInteger)c).getBytes());
                break;
            }
            case 12: {
                str = this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1) + ":" + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 15: {
                ConstantMethodHandle cmh = (ConstantMethodHandle)c;
                str = Const.getMethodHandleName(cmh.getReferenceKind()) + " " + this.constantToString(cmh.getReferenceIndex(), this.getConstant(cmh.getReferenceIndex()).getTag());
                break;
            }
            case 16: {
                ConstantMethodType cmt = (ConstantMethodType)c;
                str = this.constantToString(cmt.getDescriptorIndex(), (byte)1);
                break;
            }
            case 18: {
                ConstantInvokeDynamic cid = (ConstantInvokeDynamic)c;
                str = cid.getBootstrapMethodAttrIndex() + ":" + this.constantToString(cid.getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    private static String escape(String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len + 5);
        char[] ch = str.toCharArray();
        block7: for (int i = 0; i < len; ++i) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    public String constantToString(int index2, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index2, tag);
        return this.constantToString(c);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.constant_pool.length);
        for (int i = 1; i < this.constant_pool.length; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(file);
        }
    }

    public Constant getConstant(int index2) {
        if (index2 >= this.constant_pool.length || index2 < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index2 + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index2];
    }

    public Constant getConstant(int index2, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index2);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index2 + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index2 + " and got " + c);
        }
        return c;
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int index2, byte tag) throws ClassFormatException {
        int i;
        Constant c = this.getConstant(index2, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public int getLength() {
        return this.constant_pool == null ? 0 : this.constant_pool.length;
    }

    public void setConstant(int index2, Constant constant) {
        this.constant_pool[index2] = constant;
    }

    public void setConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.constant_pool.length; ++i) {
            buf.append(i).append(")").append(this.constant_pool[i]).append("\n");
        }
        return buf.toString();
    }

    public ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
            c.constant_pool = new Constant[this.constant_pool.length];
            for (int i = 1; i < this.constant_pool.length; ++i) {
                if (this.constant_pool[i] == null) continue;
                c.constant_pool[i] = this.constant_pool[i].copy();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }
}

