/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Hashtable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.ConsoleProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        OptionSpecBuilder syncOpt = parser.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        OptionSpecBuilder compressOpt = parser.accepts("compress", "If set, messages batches are sent compressed");
        ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = parser.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(200), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt = parser.accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(3), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Long> retryBackoffMsOpt = parser.accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(100L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> sendTimeoutOpt = parser.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting suffient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(1000L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> queueSizeOpt = parser.accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting suffient batch size.").withRequiredArg().describedAs("queue_size").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(10000L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> queueEnqueueTimeoutMsOpt = parser.accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(Integer.MAX_VALUE), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Integer> requestRequiredAcksOpt = parser.accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt = parser.accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1500), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> valueEncoderOpt = parser.accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo(StringEncoder.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> keyEncoderOpt = parser.accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo(StringEncoder.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> messageReaderOpt = parser.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo(ConsoleProducer.LineMessageReader.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = parser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(102400), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> propertyOpt = parser.accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSet options = parser.parse(args);
        ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, brokerListOpt}))).foreach(new Serializable(parser, options){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn(System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = parser$1;
                this.options$1 = options$1;
            }
        });
        String topic = options.valueOf(topicOpt);
        String brokerList = options.valueOf(brokerListOpt);
        boolean sync = options.has(syncOpt);
        boolean compress = options.has(compressOpt);
        Integer batchSize = options.valueOf(batchSizeOpt);
        Long sendTimeout = options.valueOf(sendTimeoutOpt);
        Long queueSize = options.valueOf(queueSizeOpt);
        Long queueEnqueueTimeoutMs = options.valueOf(queueEnqueueTimeoutMsOpt);
        Integer requestRequiredAcks = options.valueOf(requestRequiredAcksOpt);
        Integer requestTimeoutMs = options.valueOf(requestTimeoutMsOpt);
        String keyEncoderClass = options.valueOf(keyEncoderOpt);
        String valueEncoderClass = options.valueOf(valueEncoderOpt);
        String readerClass = options.valueOf(messageReaderOpt);
        Integer socketBuffer = options.valueOf(socketBufferSizeOpt);
        Properties cmdLineProps = this.parseLineReaderArgs(JavaConversions$.MODULE$.asScalaBuffer(options.valuesOf(propertyOpt)));
        ((Hashtable)cmdLineProps).put("topic", topic);
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", brokerList);
        int codec = compress ? DefaultCompressionCodec$.MODULE$.codec() : NoCompressionCodec$.MODULE$.codec();
        ((Hashtable)props).put("compression.codec", ((Object)BoxesRunTime.boxToInteger(codec)).toString());
        ((Hashtable)props).put("producer.type", sync ? "sync" : "async");
        Object object = options.has(batchSizeOpt) ? ((Hashtable)props).put("batch.num.messages", batchSize.toString()) : BoxedUnit.UNIT;
        ((Hashtable)props).put("message.send.max.retries", options.valueOf(messageSendMaxRetriesOpt).toString());
        ((Hashtable)props).put("retry.backoff.ms", options.valueOf(retryBackoffMsOpt).toString());
        ((Hashtable)props).put("queue.buffering.max.ms", sendTimeout.toString());
        ((Hashtable)props).put("queue.buffering.max.messages", queueSize.toString());
        ((Hashtable)props).put("queue.enqueue.timeout.ms", queueEnqueueTimeoutMs.toString());
        ((Hashtable)props).put("request.required.acks", requestRequiredAcks.toString());
        ((Hashtable)props).put("request.timeout.ms", requestTimeoutMs.toString());
        ((Hashtable)props).put("key.serializer.class", keyEncoderClass);
        ((Hashtable)props).put("serializer.class", valueEncoderClass);
        ((Hashtable)props).put("send.buffer.bytes", socketBuffer.toString());
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(readerClass).newInstance();
        reader.init(System.in, cmdLineProps);
        try {
            Producer producer = new Producer(new ProducerConfig(props));
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final Producer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            KeyedMessage message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer.send(Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseLineReaderArgs(Iterable<String> args) {
        void var3_3;
        Iterable splits = (Iterable)((TraversableLike)((TraversableLike)args.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split("=");
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$2) {
                return x$2 == null;
            }
        })).filterNot(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$3) {
                return x$3.length == 0;
            }
        });
        if (!splits.forall(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] x$4) {
                return x$4.length == 2;
            }
        })) {
            System.err.println(new StringBuilder().append((Object)"Invalid line reader properties: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props = new Properties();
        splits.foreach(new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] a) {
                return ((Hashtable)this.props$1).put(a[0], a[1]);
            }
            {
                this.props$1 = props$1;
            }
        });
        return var3_3;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

