/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.RecyclableArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collections;

final class FixedCompositeByteBuf
extends AbstractReferenceCountedByteBuf {
    private static final ByteBuf[] EMPTY = new ByteBuf[]{Unpooled.EMPTY_BUFFER};
    private final int nioBufferCount;
    private final int capacity;
    private final ByteBufAllocator allocator;
    private final ByteOrder order;
    private final Object[] buffers;
    private final boolean direct;

    FixedCompositeByteBuf(ByteBufAllocator allocator, ByteBuf ... buffers) {
        super(Integer.MAX_VALUE);
        if (buffers.length == 0) {
            this.buffers = EMPTY;
            this.order = ByteOrder.BIG_ENDIAN;
            this.nioBufferCount = 1;
            this.capacity = 0;
            this.direct = buffers[0].isDirect();
        } else {
            ByteBuf b = buffers[0];
            this.buffers = new Object[buffers.length];
            this.buffers[0] = b;
            boolean direct = true;
            int nioBufferCount = b.nioBufferCount();
            int capacity = b.readableBytes();
            this.order = b.order();
            for (int i = 1; i < buffers.length; ++i) {
                b = buffers[i];
                if (buffers[i].order() != this.order) {
                    throw new IllegalArgumentException("All ByteBufs need to have same ByteOrder");
                }
                nioBufferCount += b.nioBufferCount();
                capacity += b.readableBytes();
                if (!b.isDirect()) {
                    direct = false;
                }
                this.buffers[i] = b;
            }
            this.nioBufferCount = nioBufferCount;
            this.capacity = capacity;
            this.direct = direct;
        }
        this.setIndex(0, this.capacity());
        this.allocator = allocator;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int size2) {
        return false;
    }

    @Override
    public ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int index2, long value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int maxCapacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    private Component findComponent(int index2) {
        int readable = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            boolean isBuffer;
            ByteBuf b;
            Component comp = null;
            Object obj = this.buffers[i];
            if (obj instanceof ByteBuf) {
                b = (ByteBuf)obj;
                isBuffer = true;
            } else {
                comp = (Component)obj;
                b = comp.buf;
                isBuffer = false;
            }
            if (index2 >= (readable += b.readableBytes())) continue;
            if (isBuffer) {
                comp = new Component(i, readable - b.readableBytes(), b);
                this.buffers[i] = comp;
            }
            return comp;
        }
        throw new IllegalStateException();
    }

    private ByteBuf buffer(int i) {
        Object obj = this.buffers[i];
        if (obj instanceof ByteBuf) {
            return (ByteBuf)obj;
        }
        return ((Component)obj).buf;
    }

    @Override
    public byte getByte(int index2) {
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        Component c = this.findComponent(index2);
        return c.buf.getByte(index2 - c.offset);
    }

    @Override
    protected short _getShort(int index2) {
        Component c = this.findComponent(index2);
        if (index2 + 2 <= c.endOffset) {
            return c.buf.getShort(index2 - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(index2) & 0xFF) << 8 | this._getByte(index2 + 1) & 0xFF);
        }
        return (short)(this._getByte(index2) & 0xFF | (this._getByte(index2 + 1) & 0xFF) << 8);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        Component c = this.findComponent(index2);
        if (index2 + 3 <= c.endOffset) {
            return c.buf.getUnsignedMedium(index2 - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index2) & 0xFFFF) << 8 | this._getByte(index2 + 2) & 0xFF;
        }
        return this._getShort(index2) & 0xFFFF | (this._getByte(index2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int index2) {
        Component c = this.findComponent(index2);
        if (index2 + 4 <= c.endOffset) {
            return c.buf.getInt(index2 - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(index2) & 0xFFFF) << 16 | this._getShort(index2 + 2) & 0xFFFF;
        }
        return this._getShort(index2) & 0xFFFF | (this._getShort(index2 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected long _getLong(int index2) {
        Component c = this.findComponent(index2);
        if (index2 + 8 <= c.endOffset) {
            return c.buf.getLong(index2 - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(index2) & 0xFFFFFFFFL) << 32 | (long)this._getInt(index2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(index2) & 0xFFFFFFFFL | ((long)this._getInt(index2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.length);
        if (length == 0) {
            return this;
        }
        Component c = this.findComponent(index2);
        int i = c.index;
        int adjustment = c.offset;
        ByteBuf s2 = c.buf;
        while (true) {
            int localLength = Math.min(length, s2.readableBytes() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            adjustment += s2.readableBytes();
            if ((length -= localLength) <= 0) break;
            s2 = this.buffer(++i);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        int limit = dst.limit();
        int length = dst.remaining();
        this.checkIndex(index2, length);
        if (length == 0) {
            return this;
        }
        try {
            Component c = this.findComponent(index2);
            int i = c.index;
            int adjustment = c.offset;
            ByteBuf s2 = c.buf;
            while (true) {
                int localLength = Math.min(length, s2.readableBytes() - (index2 - adjustment));
                dst.limit(dst.position() + localLength);
                s2.getBytes(index2 - adjustment, dst);
                index2 += localLength;
                adjustment += s2.readableBytes();
                if ((length -= localLength) <= 0) {
                    break;
                }
                s2 = this.buffer(++i);
            }
        }
        finally {
            dst.limit(limit);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.capacity());
        if (length == 0) {
            return this;
        }
        Component c = this.findComponent(index2);
        int i = c.index;
        int adjustment = c.offset;
        ByteBuf s2 = c.buf;
        while (true) {
            int localLength = Math.min(length, s2.readableBytes() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, dst, dstIndex, localLength);
            index2 += localLength;
            dstIndex += localLength;
            adjustment += s2.readableBytes();
            if ((length -= localLength) <= 0) break;
            s2 = this.buffer(++i);
        }
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        int count2 = this.nioBufferCount();
        if (count2 == 1) {
            return out.write(this.internalNioBuffer(index2, length));
        }
        long writtenBytes = out.write(this.nioBuffers(index2, length));
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.checkIndex(index2, length);
        if (length == 0) {
            return this;
        }
        Component c = this.findComponent(index2);
        int i = c.index;
        int adjustment = c.offset;
        ByteBuf s2 = c.buf;
        while (true) {
            int localLength = Math.min(length, s2.readableBytes() - (index2 - adjustment));
            s2.getBytes(index2 - adjustment, out, localLength);
            index2 += localLength;
            adjustment += s2.readableBytes();
            if ((length -= localLength) <= 0) break;
            s2 = this.buffer(++i);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex(index2, length);
        boolean release = true;
        ByteBuf buf = this.alloc().buffer(length);
        try {
            buf.writeBytes(this, index2, length);
            release = false;
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
        finally {
            if (release) {
                buf.release();
            }
        }
    }

    @Override
    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        ByteBuf buf;
        this.checkIndex(index2, length);
        if (this.buffers.length == 1 && (buf = this.buffer(0)).nioBufferCount() == 1) {
            return buf.nioBuffer(index2, length);
        }
        ByteBuffer merged = ByteBuffer.allocate(length).order(this.order());
        ByteBuffer[] buffers = this.nioBuffers(index2, length);
        for (int i = 0; i < buffers.length; ++i) {
            merged.put(buffers[i]);
        }
        merged.flip();
        return merged;
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        if (this.buffers.length == 1) {
            return this.buffer(0).internalNioBuffer(index2, length);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        this.checkIndex(index2, length);
        if (length == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        RecyclableArrayList array = RecyclableArrayList.newInstance(this.buffers.length);
        try {
            Component c = this.findComponent(index2);
            int i = c.index;
            int adjustment = c.offset;
            ByteBuf s2 = c.buf;
            while (true) {
                int localLength = Math.min(length, s2.readableBytes() - (index2 - adjustment));
                switch (s2.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        array.add(s2.nioBuffer(index2 - adjustment, localLength));
                        break;
                    }
                    default: {
                        Collections.addAll(array, s2.nioBuffers(index2 - adjustment, localLength));
                    }
                }
                index2 += localLength;
                adjustment += s2.readableBytes();
                if ((length -= localLength) <= 0) break;
                s2 = this.buffer(++i);
            }
            ByteBuffer[] byteBufferArray = array.toArray(new ByteBuffer[array.size()]);
            return byteBufferArray;
        }
        finally {
            array.recycle();
        }
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deallocate() {
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffer(i).release();
        }
    }

    @Override
    public String toString() {
        String result2 = super.toString();
        result2 = result2.substring(0, result2.length() - 1);
        return result2 + ", components=" + this.buffers.length + ')';
    }

    private static final class Component {
        private final int index;
        private final int offset;
        private final ByteBuf buf;
        private final int endOffset;

        Component(int index2, int offset, ByteBuf buf) {
            this.index = index2;
            this.offset = offset;
            this.endOffset = offset + buf.readableBytes();
            this.buf = buf;
        }
    }
}

