/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.corelib.definitions.jibx.AudioChannelNumber;
import eu.europeana.corelib.definitions.jibx.BitRate;
import eu.europeana.corelib.definitions.jibx.CodecName;
import eu.europeana.corelib.definitions.jibx.ColorSpaceType;
import eu.europeana.corelib.definitions.jibx.DoubleType;
import eu.europeana.corelib.definitions.jibx.Duration;
import eu.europeana.corelib.definitions.jibx.HasColorSpace;
import eu.europeana.corelib.definitions.jibx.HasMimeType;
import eu.europeana.corelib.definitions.jibx.Height;
import eu.europeana.corelib.definitions.jibx.HexBinaryType;
import eu.europeana.corelib.definitions.jibx.IntegerType;
import eu.europeana.corelib.definitions.jibx.LongType;
import eu.europeana.corelib.definitions.jibx.NonNegativeIntegerType;
import eu.europeana.corelib.definitions.jibx.OrientationType;
import eu.europeana.corelib.definitions.jibx.SampleRate;
import eu.europeana.corelib.definitions.jibx.SampleSize;
import eu.europeana.corelib.definitions.jibx.SpatialResolution;
import eu.europeana.corelib.definitions.jibx.StringType;
import eu.europeana.corelib.definitions.jibx.Type1;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.corelib.definitions.jibx.Width;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class WebResource {
    protected static final String FULL_TEXT_RESOURCE = "http://www.europeana.eu/schemas/edm/FullTextResource";
    private final WebResourceType resource;

    WebResource(WebResourceType resource) {
        this.resource = resource;
    }

    void setWidth(int width) {
        this.resource.setWidth(WebResource.intVal(Width::new, width));
    }

    void setHeight(int height) {
        this.resource.setHeight(WebResource.intVal(Height::new, height));
    }

    void setMimeType(String mimeType) {
        HasMimeType hasMimeType = new HasMimeType();
        hasMimeType.setHasMimeType(mimeType);
        this.resource.setHasMimeType(hasMimeType);
    }

    void setFileSize(long fileSize) {
        this.resource.setFileByteSize(WebResource.longVal(fileSize));
    }

    void setColorspace(ColorSpaceType colorSpace) {
        HasColorSpace hasColorSpace = new HasColorSpace();
        hasColorSpace.setHasColorSpace(colorSpace);
        this.resource.setHasColorSpace(hasColorSpace);
    }

    void setOrientation(Orientation orientation) {
        this.resource.setOrientation(WebResource.stringVal(OrientationType::new, orientation.name().toLowerCase(Locale.ENGLISH)));
    }

    void setDominantColors(List<String> dominantColors) {
        this.resource.setComponentColorList(dominantColors.stream().map(c -> {
            HexBinaryType hex = new HexBinaryType();
            hex.setString((String)c);
            hex.setDatatype("http://www.w3.org/2001/XMLSchema#hexBinary");
            return hex;
        }).collect(Collectors.toList()));
    }

    void setDuration(double seconds) {
        int millisInSecond = 1000;
        Duration duration2 = new Duration();
        duration2.setDuration(Integer.toString((int)Math.round(seconds * 1000.0)));
        this.resource.setDuration(duration2);
    }

    void setBitrate(int bitrate) {
        this.resource.setBitRate(WebResource.uintVal(BitRate::new, bitrate));
    }

    void setFrameRete(double frameRate) {
        this.resource.setFrameRate(WebResource.doubleVal(frameRate));
    }

    void setCodecName(String codecName) {
        CodecName codecName2 = new CodecName();
        codecName2.setCodecName(codecName);
        this.resource.setCodecName(codecName2);
    }

    void setChannels(int channels) {
        this.resource.setAudioChannelNumber(WebResource.uintVal(AudioChannelNumber::new, channels));
    }

    void setSampleRate(int sampleRate) {
        this.resource.setSampleRate(WebResource.intVal(SampleRate::new, sampleRate));
    }

    void setSampleSize(int sampleSize) {
        this.resource.setSampleSize(WebResource.intVal(SampleSize::new, sampleSize));
    }

    void setContainsText(boolean containsText) {
        if (containsText) {
            Type1 type = new Type1();
            type.setResource(FULL_TEXT_RESOURCE);
            this.resource.setType(type);
        } else {
            this.resource.setType(null);
        }
    }

    void setResolution(Integer resolution) {
        this.resource.setSpatialResolution(resolution == null ? null : WebResource.uintVal(SpatialResolution::new, resolution));
    }

    private static <T extends IntegerType> T intVal(Supplier<T> constructor, int value2) {
        IntegerType element = (IntegerType)constructor.get();
        element.setLong(value2);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#integer");
        return (T)element;
    }

    private static <T extends NonNegativeIntegerType> T uintVal(Supplier<T> constructor, int value2) {
        NonNegativeIntegerType element = (NonNegativeIntegerType)constructor.get();
        element.setInteger(BigInteger.valueOf(value2));
        element.setDatatype("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        return (T)element;
    }

    private static LongType longVal(long value2) {
        LongType element = new LongType();
        element.setLong(value2);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#long");
        return element;
    }

    private static DoubleType doubleVal(double value2) {
        DoubleType element = new DoubleType();
        element.setDouble(value2);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#double");
        return element;
    }

    private static <T extends StringType> T stringVal(Supplier<T> constructor, String value2) {
        StringType element = (StringType)constructor.get();
        element.setString(value2);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#string");
        return (T)element;
    }

    public static enum Orientation {
        PORTRAIT,
        LANDSCAPE;

    }
}

