/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum UrlType {
    OBJECT,
    HAS_VIEW,
    IS_SHOWN_BY,
    IS_SHOWN_AT;

    public static final Set<UrlType> URL_TYPES_FOR_LINK_CHECKING;
    public static final Set<UrlType> URL_TYPES_FOR_MEDIA_EXTRACTION;
    public static final Set<UrlType> URL_TYPES_FOR_METADATA_EXTRACTION;

    public static boolean shouldExtractMetadata(Collection<UrlType> resourceTypes) {
        return resourceTypes.stream().anyMatch(URL_TYPES_FOR_METADATA_EXTRACTION::contains);
    }

    static {
        URL_TYPES_FOR_LINK_CHECKING = Collections.unmodifiableSet(EnumSet.allOf(UrlType.class));
        URL_TYPES_FOR_MEDIA_EXTRACTION = Collections.unmodifiableSet(EnumSet.allOf(UrlType.class));
        URL_TYPES_FOR_METADATA_EXTRACTION = Collections.unmodifiableSet(EnumSet.allOf(UrlType.class));
    }
}

