/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.corelib.definitions.jibx.Preview;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdf;
import eu.europeana.metis.mediaprocessing.model.RdfWrapper;
import eu.europeana.metis.mediaprocessing.model.ResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import eu.europeana.metis.mediaprocessing.model.WebResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class EnrichedRdfImpl
extends RdfWrapper
implements EnrichedRdf {
    private final Map<String, Set<String>> thumbnailTargetNames = new HashMap<String, Set<String>>();

    public EnrichedRdfImpl(RDF rdf) {
        super(rdf);
    }

    private WebResource getWebResource(String url) {
        if (this.getRdf().getWebResourceList() == null) {
            this.getRdf().setWebResourceList(new ArrayList<WebResourceType>());
        }
        for (WebResourceType resource : this.getRdf().getWebResourceList()) {
            if (!resource.getAbout().equals(url)) continue;
            return new WebResource(resource);
        }
        WebResourceType resource = new WebResourceType();
        resource.setAbout(url);
        this.getRdf().getWebResourceList().add(resource);
        return new WebResource(resource);
    }

    @Override
    public void enrichResource(ResourceMetadata resource) {
        WebResource webResource = this.getWebResource(resource.getResourceUrl());
        resource.getMetaData().updateResource(webResource);
        this.thumbnailTargetNames.put(resource.getResourceUrl(), resource.getThumbnailTargetNames());
    }

    @Override
    public RDF finalizeRdf() {
        String edmPreviewUrl = this.getEdmPreviewUrl();
        this.updateEdmPreview(edmPreviewUrl);
        return this.getRdf();
    }

    String getEdmPreviewUrl() {
        Set<String> objectUrls = this.getResourceUrls(Collections.singleton(UrlType.OBJECT)).keySet();
        if (!objectUrls.isEmpty()) {
            return objectUrls.iterator().next();
        }
        EnumSet<UrlType> otherTypes = EnumSet.of(UrlType.IS_SHOWN_BY, UrlType.HAS_VIEW);
        Set<String> otherUrls = this.getResourceUrls(otherTypes).keySet();
        return this.getResourceUrls().stream().filter(otherUrls::contains).map(this::getThumbnailTargetNames).map(this::getEligiblePreviewThumbnail).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String getEligiblePreviewThumbnail(Set<String> targetNames) {
        return targetNames.stream().filter(name -> name.contains("-LARGE")).findAny().orElse(null);
    }

    void updateEdmPreview(String url) {
        if (url != null && this.getRdf().getEuropeanaAggregationList() != null && !this.getRdf().getEuropeanaAggregationList().isEmpty()) {
            Preview preview = new Preview();
            preview.setResource(url);
            this.getRdf().getEuropeanaAggregationList().get(0).setPreview(preview);
        }
    }

    Set<String> getResourceUrls() {
        return Collections.unmodifiableSet(this.thumbnailTargetNames.keySet());
    }

    Set<String> getThumbnailTargetNames(String resourceUrl) {
        return Optional.ofNullable(this.thumbnailTargetNames.get(resourceUrl)).map(Collections::unmodifiableSet).orElse(null);
    }
}

