/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.extraction.ThumbnailGenerator;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResult;
import eu.europeana.metis.mediaprocessing.model.TextResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextProcessor
implements MediaProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextProcessor.class);
    private static final String PDF_MIME_TYPE = "application/pdf";
    protected static final int DISPLAY_DPI = 72;
    private final ThumbnailGenerator thumbnailGenerator;

    TextProcessor(ThumbnailGenerator thumbnailGenerator) {
        this.thumbnailGenerator = thumbnailGenerator;
    }

    @Override
    public ResourceExtractionResult process(Resource resource, String detectedMimeType) throws MediaExtractionException {
        long contentSize;
        PdfCharacteristics characteristics;
        if (!this.shouldExtractMetadata(resource)) {
            return null;
        }
        try {
            if (!resource.hasContent()) {
                throw new MediaExtractionException("File does not exist or does not have content.");
            }
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
        List<Thumbnail> thumbnails = PDF_MIME_TYPE.equals(detectedMimeType) ? this.thumbnailGenerator.generateThumbnails(resource.getResourceUrl(), detectedMimeType, resource.getContentFile()).getRight() : null;
        if (PDF_MIME_TYPE.equals(detectedMimeType)) {
            characteristics = this.findPdfCharacteristics(resource.getContentFile());
        } else {
            boolean hasText = detectedMimeType.startsWith("text/") || "application/xhtml+xml".equals(detectedMimeType);
            characteristics = new PdfCharacteristics(hasText, null);
        }
        try {
            contentSize = resource.getContentSize();
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine the size of the resource " + resource.getResourceUrl(), e);
        }
        TextResourceMetadata metadata = new TextResourceMetadata(detectedMimeType, resource.getResourceUrl(), contentSize, characteristics.containsText(), characteristics.getResolution(), thumbnails);
        return new ResourceExtractionResult(metadata, thumbnails);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PdfCharacteristics findPdfCharacteristics(File content) throws MediaExtractionException {
        try (OpenPdfFile openPdf = this.openPdfFile(content);){
            for (int i = 1; i <= openPdf.getNumberOfPages(); ++i) {
                openPdf.getPdfParser().processContent(i, openPdf.getPdfListener());
                if (openPdf.getPdfListener().getDpi() != null && openPdf.getPdfListener().hasText()) break;
            }
            PdfCharacteristics pdfCharacteristics = new PdfCharacteristics(openPdf.getPdfListener().hasText(), openPdf.getPdfListener().getDpi());
            return pdfCharacteristics;
        }
        catch (IOException e) {
            throw new MediaExtractionException("Problem while reading PDF file.", e);
        }
    }

    OpenPdfFile openPdfFile(File content) throws IOException {
        return new OpenPdfFile(content);
    }

    static class PdfListener
    implements RenderListener {
        private Integer dpi = null;
        private boolean hasText = false;

        PdfListener() {
        }

        Integer getDpi() {
            return this.dpi;
        }

        boolean hasText() {
            return this.hasText;
        }

        @Override
        public void beginTextBlock() {
        }

        @Override
        public void endTextBlock() {
        }

        @Override
        public void renderText(TextRenderInfo renderInfo) {
            this.hasText = this.hasText || !renderInfo.getText().isEmpty();
        }

        @Override
        public void renderImage(ImageRenderInfo iri) {
            if (this.dpi != null) {
                return;
            }
            try {
                BufferedImage image = iri.getImage().getBufferedImage();
                if (image == null) {
                    return;
                }
                int widthInPixels = image.getWidth();
                int heightInPixels = image.getHeight();
                Matrix imageMatrix = iri.getImageCTM();
                double widthInInches = (double)imageMatrix.get(0) / 72.0;
                double heightInInches = (double)imageMatrix.get(4) / 72.0;
                long xDpi = Math.abs(Math.round((double)widthInPixels / widthInInches));
                long yDpi = Math.abs(Math.round((double)heightInPixels / heightInInches));
                this.dpi = (int)Math.min(xDpi, yDpi);
            }
            catch (IOException e) {
                LOGGER.info("Could not extract PDF image", e);
            }
        }
    }

    static class PdfCharacteristics {
        private final boolean containsText;
        private final Integer resolution;

        PdfCharacteristics(boolean containsText, Integer resolution) {
            this.containsText = containsText;
            this.resolution = resolution;
        }

        boolean containsText() {
            return this.containsText;
        }

        Integer getResolution() {
            return this.resolution;
        }
    }

    static class OpenPdfFile
    implements Closeable {
        private final PdfReader pdfReader;
        private PdfListener pdfListener;
        private PdfReaderContentParser pdfParser;

        OpenPdfFile(File content) throws IOException {
            this.pdfReader = new PdfReader(content.getAbsolutePath());
        }

        int getNumberOfPages() {
            return this.pdfReader.getNumberOfPages();
        }

        PdfListener getPdfListener() {
            this.pdfListener = this.pdfListener == null ? new PdfListener() : this.pdfListener;
            return this.pdfListener;
        }

        PdfReaderContentParser getPdfParser() {
            this.pdfParser = this.pdfParser == null ? new PdfReaderContentParser(this.pdfReader) : this.pdfParser;
            return this.pdfParser;
        }

        @Override
        public void close() {
            this.pdfReader.close();
        }
    }
}

