/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float hashTableLoadFactor = 0.75f;
    private int hits = 0;
    private int miss = 0;
    private LinkedHashMap<K, V> map;
    private int cacheSize;

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LRUCache.this.cacheSize;
            }
        };
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public void put(K key, V value2) {
        this.map.put(key, value2);
    }

    public void clear() {
        this.map.clear();
    }

    public int usedEntries() {
        return this.map.size();
    }

    public boolean containsKey(K k) {
        if (this.map.containsKey(k)) {
            ++this.hits;
            return true;
        }
        ++this.miss;
        return false;
    }

    public double hitRate() {
        return (double)this.hits / (double)(this.hits + this.miss);
    }
}

