/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.HashSet;
import java.util.Set;

public class CassandraAttributeStatisticsDAO
extends CassandraDAO {
    public static final int MAX_ALLOWED_VALUES = 15;
    private static CassandraAttributeStatisticsDAO instance = null;
    private PreparedStatement updateAttributeStatement;
    private PreparedStatement selectAttributesStatement;
    private PreparedStatement countDistinctAttributeValues;
    private PreparedStatement countSpecificAttributeValue;

    public static synchronized CassandraAttributeStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new CassandraAttributeStatisticsDAO(cassandra);
        }
        return instance;
    }

    private CassandraAttributeStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.updateAttributeStatement = this.dbService.getSession().prepare("UPDATE attribute_statistics SET occurrence = occurrence + ? WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ? AND attribute_value = ?");
        this.updateAttributeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.selectAttributesStatement = this.dbService.getSession().prepare("SELECT * FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? LIMIT 2");
        this.selectAttributesStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.countDistinctAttributeValues = this.dbService.getSession().prepare("SELECT count(*) FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ?");
        this.countDistinctAttributeValues.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.countSpecificAttributeValue = this.dbService.getSession().prepare("SELECT count(*) FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? AND attribute_name = ? AND attribute_value = ?");
        this.countSpecificAttributeValue.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void insertAttributeStatistics(long taskId, String nodeXpath, String nodeValue, Set<AttributeStatistics> attributes) {
        for (AttributeStatistics attributeStatistics : attributes) {
            long distinctValuesCount = this.getAttributeDistinctValues(taskId, nodeXpath, nodeValue, attributeStatistics.getName());
            if (distinctValuesCount >= 15L) {
                long currentCount = this.getSpecificAttributeValueCount(taskId, nodeXpath, nodeValue, attributeStatistics.getName(), attributeStatistics.getValue());
                if (currentCount <= 0L) continue;
                this.insertAttributeStatistics(taskId, nodeXpath, nodeValue, attributeStatistics);
                continue;
            }
            this.insertAttributeStatistics(taskId, nodeXpath, nodeValue, attributeStatistics);
        }
    }

    private long getAttributeDistinctValues(long taskId, String nodePath, String nodeValue, String attributeName) {
        ResultSet rs = this.dbService.getSession().execute(this.countDistinctAttributeValues.bind(taskId, nodePath, nodeValue, attributeName));
        return rs.one().getLong(0);
    }

    private long getSpecificAttributeValueCount(long taskId, String nodePath, String nodeValue, String attributeName, String attributeValue) {
        ResultSet rs = this.dbService.getSession().execute(this.countSpecificAttributeValue.bind(taskId, nodePath, nodeValue, attributeName, attributeValue));
        return rs.one().getLong(0);
    }

    public void insertAttributeStatistics(long taskId, String nodeXpath, String nodeValue, AttributeStatistics attributeStatistics) {
        this.dbService.getSession().execute(this.updateAttributeStatement.bind(attributeStatistics.getOccurrence(), taskId, nodeXpath, nodeValue, attributeStatistics.getName(), attributeStatistics.getValue()));
    }

    public Set<AttributeStatistics> getAttributeStatistics(long taskId, String nodeXpath, String nodeValue) {
        BoundStatement bs = this.selectAttributesStatement.bind(taskId, nodeXpath, nodeValue);
        ResultSet rs = this.dbService.getSession().execute(bs);
        HashSet<AttributeStatistics> result2 = new HashSet<AttributeStatistics>();
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            result2.add(new AttributeStatistics(row.getString("attribute_name"), row.getString("attribute_value"), row.getLong("occurrence")));
        }
        return result2;
    }
}

