/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.link.check;

import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.topologies.link.check.FileInfo;
import eu.europeana.cloud.service.dps.storm.topologies.link.check.ResourceInfo;
import eu.europeana.metis.mediaprocessing.LinkChecker;
import eu.europeana.metis.mediaprocessing.MediaProcessorFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkCheckBolt
extends AbstractDpsBolt {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkCheckBolt.class);
    private static final int CACHE_SIZE = 1024;
    Map<String, FileInfo> cache = new HashMap<String, FileInfo>(1024);
    private LinkChecker linkChecker;

    @Override
    public void prepare() {
        try {
            MediaProcessorFactory processorFactory = new MediaProcessorFactory();
            this.linkChecker = processorFactory.createLinkChecker();
        }
        catch (Exception e) {
            String errorMessage = "error while initializing Link checker";
            LOGGER.error(errorMessage + " " + e.getCause());
            throw new RuntimeException("error while initializing Link checker", e);
        }
    }

    @Override
    public void execute(StormTaskTuple tuple) {
        ResourceInfo resourceInfo = this.readResourceInfoFromTuple(tuple);
        if (!this.hasLinksForCheck(resourceInfo)) {
            this.emitSuccessNotification(tuple.getTaskId(), tuple.getFileUrl(), "", "The EDM file has no resources", "");
        } else {
            FileInfo edmFile = this.checkProvidedLink(resourceInfo);
            if (this.isFileFullyProcessed(edmFile)) {
                this.removeFileFromCache(edmFile);
                if (edmFile.errors == null || edmFile.errors.isEmpty()) {
                    this.emitSuccessNotification(tuple.getTaskId(), tuple.getFileUrl(), "", "", "");
                } else {
                    this.emitSuccessNotification(tuple.getTaskId(), tuple.getFileUrl(), "", "", "", "resource exception", edmFile.errors);
                }
            }
        }
    }

    private ResourceInfo readResourceInfoFromTuple(StormTaskTuple tuple) {
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.expectedSize = Integer.parseInt(tuple.getParameter("RESOURCE_LINKS_COUNT"));
        resourceInfo.edmUrl = tuple.getFileUrl();
        resourceInfo.linkUrl = tuple.getParameter("RESOURCE_URL");
        return resourceInfo;
    }

    private boolean hasLinksForCheck(ResourceInfo resourceInfo) {
        return resourceInfo.expectedSize > 0;
    }

    private FileInfo checkProvidedLink(ResourceInfo resourceInfo) {
        FileInfo edmFile = this.takeFileFromCache(resourceInfo);
        if (edmFile == null) {
            edmFile = new FileInfo(resourceInfo.edmUrl, resourceInfo.expectedSize, 0);
            this.checkLink(resourceInfo, edmFile);
            this.putFileToCache(edmFile);
        } else {
            this.checkLink(resourceInfo, edmFile);
        }
        return edmFile;
    }

    private boolean isFileFullyProcessed(FileInfo fileInfo) {
        return fileInfo.linksChecked >= fileInfo.expectedNumberOfLinks;
    }

    private FileInfo takeFileFromCache(ResourceInfo resourceInfo) {
        return this.cache.get(resourceInfo.edmUrl);
    }

    private void putFileToCache(FileInfo fileInfo) {
        this.cache.put(fileInfo.fileUrl, fileInfo);
    }

    private void removeFileFromCache(FileInfo fileInfo) {
        this.cache.remove(fileInfo.fileUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLink(ResourceInfo resourceInfo, FileInfo fileInfo) {
        LOGGER.info("Checking resource url {}", (Object)resourceInfo.edmUrl);
        try {
            this.linkChecker.performLinkChecking(resourceInfo.linkUrl);
        }
        catch (Exception e) {
            LOGGER.info("There was exception while checking the link: {}", (Object)resourceInfo.edmUrl);
            String error = e.getMessage() + " . Because of: " + e.getCause();
            fileInfo.errors = fileInfo.errors == null || fileInfo.errors.isEmpty() ? error : fileInfo.errors + "," + error;
        }
        finally {
            ++fileInfo.linksChecked;
        }
    }
}

