/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.coordination.provider;

import eu.europeana.cloud.service.coordination.ServiceProperties;
import eu.europeana.cloud.service.coordination.discovery.EcloudServiceDiscovery;
import eu.europeana.cloud.service.coordination.provider.ServiceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProviderImpl
implements ServiceProvider {
    private EcloudServiceDiscovery serviceDiscovery;
    private final String preferredDatacenter;
    private final Random random = new Random();
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProviderImpl.class);

    public ServiceProviderImpl(EcloudServiceDiscovery serviceDiscovery, String preferredDatacenter) {
        LOGGER.info("Starting ServiceProviderImpl...");
        this.serviceDiscovery = serviceDiscovery;
        this.preferredDatacenter = preferredDatacenter;
        LOGGER.info("ServiceProviderImpl started succesfully.");
    }

    @Override
    public ServiceProperties getService() {
        List<ServiceProperties> services = this.serviceDiscovery.getServices();
        return this.getRandomLocalService(services, this.preferredDatacenter);
    }

    private ServiceProperties getRandomLocalService(List<ServiceProperties> allServices, String preferredDatacenter) {
        int randomIndex;
        int allServicesSize = allServices.size();
        if (allServicesSize == 0) {
            LOGGER.warn("getRandomLocalService() no service found!");
            return null;
        }
        ArrayList<ServiceProperties> localServices = new ArrayList<ServiceProperties>();
        for (ServiceProperties currentService : allServices) {
            if (!currentService.getDatacenterLocation().equals(preferredDatacenter)) continue;
            localServices.add(currentService);
        }
        int localServicesSize = localServices.size();
        if (localServicesSize == 0) {
            randomIndex = this.random.nextInt(allServicesSize);
            LOGGER.info("getRandomLocalService() no service available from data center={}", (Object)preferredDatacenter);
            allServices.get(randomIndex);
        }
        randomIndex = this.random.nextInt(localServicesSize);
        return (ServiceProperties)localServices.get(randomIndex);
    }
}

