/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.coordination;

import com.google.common.base.Throwables;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.EnsurePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperService.class);
    private final CuratorFramework zkClient;
    private static final RetryPolicy ZOOKEEPER_RETRY_POLICY = new ExponentialBackoffRetry(1000, 3);
    private final String zookeeperPath;

    public ZookeeperService(String zookeeperAddress, int zookeeperConnectionTimeout, int zookeeperSessionTimeout, String zookeeperPath) {
        LOGGER.info("ZookeeperService starting...");
        this.zookeeperPath = zookeeperPath;
        this.zkClient = CuratorFrameworkFactory.builder().connectionTimeoutMs(zookeeperConnectionTimeout).retryPolicy(ZOOKEEPER_RETRY_POLICY).sessionTimeoutMs(zookeeperSessionTimeout).connectString(zookeeperAddress).build();
        this.zkClient.start();
        try {
            new EnsurePath(zookeeperPath).ensure(this.zkClient.getZookeeperClient());
            LOGGER.info("ZookeeperService started successfully.");
        }
        catch (Exception e) {
            LOGGER.error("ZooKeeper base path '{}' not found... Exception='{}'.  The path must be manually created in zookeeper, and is needed for configuration settings retrieval and service registration.", (Object)zookeeperPath, (Object)e.getMessage());
            throw Throwables.propagate(e);
        }
    }

    public String getZookeeperPath() {
        return this.zookeeperPath;
    }

    public CuratorFramework getClient() {
        return this.zkClient;
    }
}

