/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.logging;

import eu.europeana.cloud.service.commons.logging.LoggingConfigurator;
import java.util.Enumeration;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import kafka.producer.KafkaLog4jAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jndi.JndiTemplate;

public class SimpleLoggingConfigurator
extends LoggingConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLoggingConfigurator.class);
    private static final String EUROPEANA_CLOUD_LOGGER_NAME = "eu.europeana.cloud.service.commons.logging.LoggingFilter";
    private static final String KAFKA_APPENDER_NAME = "KAFKA";
    private static final String KAFKA_BROKER_LIST_JNDI_NAME = "java:comp/env/logging/kafka/brokerList";

    @Override
    @PostConstruct
    public void configure() {
        LOGGER.info("Start configuring logging system");
        String hostname = this.readHostname(null);
        this.configureKafkaLogger(hostname);
        this.configureRootLogger(hostname);
        LOGGER.info("Logging system configuration finished");
    }

    private void configureKafkaLogger(String hostname) {
        org.apache.log4j.Logger europeanaLogger = org.apache.log4j.Logger.getLogger((String)EUROPEANA_CLOUD_LOGGER_NAME);
        try {
            if (this.isKafkaAppenderDefined(europeanaLogger)) {
                this.configureKafkaAppender(europeanaLogger);
            }
        }
        catch (NamingException ex) {
            this.removeKafkaAppenderFromLogger(europeanaLogger);
            LOGGER.error("Name {} not found in JNDI.", (Object)KAFKA_BROKER_LIST_JNDI_NAME);
        }
        this.turnOnLogger(europeanaLogger);
        this.loggerUpdater.update(europeanaLogger, "instanceName", hostname);
    }

    private void configureRootLogger(String hostname) {
        org.apache.log4j.Logger applicationRootLogger = org.apache.log4j.Logger.getRootLogger();
        this.loggerUpdater.update(applicationRootLogger, "instanceName", hostname);
    }

    private boolean isKafkaAppenderDefined(org.apache.log4j.Logger logger) {
        if (logger != null) {
            Appender kafkaAppender = logger.getAppender(KAFKA_APPENDER_NAME);
            return kafkaAppender != null;
        }
        return false;
    }

    private void configureKafkaAppender(org.apache.log4j.Logger logger) throws NamingException {
        Enumeration appenderEnumerator = logger.getAllAppenders();
        while (appenderEnumerator.hasMoreElements()) {
            Appender appender = (Appender)appenderEnumerator.nextElement();
            if (!(appender instanceof KafkaLog4jAppender)) continue;
            KafkaLog4jAppender kafkaAppender = (KafkaLog4jAppender)appender;
            String brokerList = this.readKafkaBrokerListFromJNDI();
            kafkaAppender.setBrokerList(brokerList);
            kafkaAppender.activateOptions();
        }
    }

    private String readKafkaBrokerListFromJNDI() throws NamingException {
        JndiTemplate jndi = new JndiTemplate();
        return jndi.lookup(KAFKA_BROKER_LIST_JNDI_NAME).toString();
    }

    private void removeKafkaAppenderFromLogger(org.apache.log4j.Logger logger) {
        logger.removeAppender(KAFKA_APPENDER_NAME);
    }

    private void turnOnLogger(org.apache.log4j.Logger logger) {
        if (logger != null) {
            logger.setLevel(Level.INFO);
        }
    }
}

