/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.xmp.options;

import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.options.Options;

public final class SerializeOptions
extends Options {
    public static final int OMIT_PACKET_WRAPPER = 16;
    public static final int READONLY_PACKET = 32;
    public static final int USE_COMPACT_FORMAT = 64;
    public static final int USE_CANONICAL_FORMAT = 128;
    public static final int INCLUDE_THUMBNAIL_PAD = 256;
    public static final int EXACT_PACKET_LENGTH = 512;
    public static final int OMIT_XMPMETA_ELEMENT = 4096;
    public static final int SORT = 8192;
    private static final int LITTLEENDIAN_BIT = 1;
    private static final int UTF16_BIT = 2;
    public static final int ENCODE_UTF8 = 0;
    public static final int ENCODE_UTF16BE = 2;
    public static final int ENCODE_UTF16LE = 3;
    private static final int ENCODING_MASK = 3;
    private int padding = 2048;
    private String newline = "\n";
    private String indent = "  ";
    private int baseIndent = 0;
    private boolean omitVersionAttribute = false;

    public SerializeOptions() {
    }

    public SerializeOptions(int options) throws XMPException {
        super(options);
    }

    public boolean getOmitPacketWrapper() {
        return this.getOption(16);
    }

    public SerializeOptions setOmitPacketWrapper(boolean value2) {
        this.setOption(16, value2);
        return this;
    }

    public boolean getOmitXmpMetaElement() {
        return this.getOption(4096);
    }

    public SerializeOptions setOmitXmpMetaElement(boolean value2) {
        this.setOption(4096, value2);
        return this;
    }

    public boolean getReadOnlyPacket() {
        return this.getOption(32);
    }

    public SerializeOptions setReadOnlyPacket(boolean value2) {
        this.setOption(32, value2);
        return this;
    }

    public boolean getUseCompactFormat() {
        return this.getOption(64);
    }

    public SerializeOptions setUseCompactFormat(boolean value2) {
        this.setOption(64, value2);
        return this;
    }

    public boolean getUseCanonicalFormat() {
        return this.getOption(128);
    }

    public SerializeOptions setUseCanonicalFormat(boolean value2) {
        this.setOption(128, value2);
        return this;
    }

    public boolean getIncludeThumbnailPad() {
        return this.getOption(256);
    }

    public SerializeOptions setIncludeThumbnailPad(boolean value2) {
        this.setOption(256, value2);
        return this;
    }

    public boolean getExactPacketLength() {
        return this.getOption(512);
    }

    public SerializeOptions setExactPacketLength(boolean value2) {
        this.setOption(512, value2);
        return this;
    }

    public boolean getSort() {
        return this.getOption(8192);
    }

    public SerializeOptions setSort(boolean value2) {
        this.setOption(8192, value2);
        return this;
    }

    public boolean getEncodeUTF16BE() {
        return (this.getOptions() & 3) == 2;
    }

    public SerializeOptions setEncodeUTF16BE(boolean value2) {
        this.setOption(3, false);
        this.setOption(2, value2);
        return this;
    }

    public boolean getEncodeUTF16LE() {
        return (this.getOptions() & 3) == 3;
    }

    public SerializeOptions setEncodeUTF16LE(boolean value2) {
        this.setOption(3, false);
        this.setOption(3, value2);
        return this;
    }

    public int getBaseIndent() {
        return this.baseIndent;
    }

    public SerializeOptions setBaseIndent(int baseIndent) {
        this.baseIndent = baseIndent;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public SerializeOptions setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public String getNewline() {
        return this.newline;
    }

    public SerializeOptions setNewline(String newline) {
        this.newline = newline;
        return this;
    }

    public int getPadding() {
        return this.padding;
    }

    public SerializeOptions setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public boolean getOmitVersionAttribute() {
        return this.omitVersionAttribute;
    }

    public String getEncoding() {
        if (this.getEncodeUTF16BE()) {
            return "UTF-16BE";
        }
        if (this.getEncodeUTF16LE()) {
            return "UTF-16LE";
        }
        return "UTF-8";
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            SerializeOptions clone2 = new SerializeOptions(this.getOptions());
            clone2.setBaseIndent(this.baseIndent);
            clone2.setIndent(this.indent);
            clone2.setNewline(this.newline);
            clone2.setPadding(this.padding);
            return clone2;
        }
        catch (XMPException e) {
            return null;
        }
    }

    protected String defineOptionName(int option) {
        switch (option) {
            case 16: {
                return "OMIT_PACKET_WRAPPER";
            }
            case 32: {
                return "READONLY_PACKET";
            }
            case 64: {
                return "USE_COMPACT_FORMAT";
            }
            case 256: {
                return "INCLUDE_THUMBNAIL_PAD";
            }
            case 512: {
                return "EXACT_PACKET_LENGTH";
            }
            case 4096: {
                return "OMIT_XMPMETA_ELEMENT";
            }
            case 8192: {
                return "NORMALIZED";
            }
        }
        return null;
    }

    protected int getValidOptions() {
        return 13168;
    }
}

