/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.xmp.impl;

import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.impl.ByteBuffer;
import com.itextpdf.xmp.impl.FixASCIIControlsReader;
import com.itextpdf.xmp.impl.Latin1Converter;
import com.itextpdf.xmp.impl.ParameterAsserts;
import com.itextpdf.xmp.impl.ParseRDF;
import com.itextpdf.xmp.impl.XMPMetaImpl;
import com.itextpdf.xmp.impl.XMPNormalizer;
import com.itextpdf.xmp.options.ParseOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMPMetaParser {
    private static final Object XMP_RDF = new Object();
    private static DocumentBuilderFactory factory = XMPMetaParser.createDocumentBuilderFactory();

    private XMPMetaParser() {
    }

    public static XMPMeta parse(Object input2, ParseOptions options) throws XMPException {
        ParameterAsserts.assertNotNull(input2);
        options = options != null ? options : new ParseOptions();
        Document document2 = XMPMetaParser.parseXml(input2, options);
        boolean xmpmetaRequired = options.getRequireXMPMeta();
        Object[] result2 = new Object[3];
        result2 = XMPMetaParser.findRootNode(document2, xmpmetaRequired, result2);
        if (result2 != null && result2[1] == XMP_RDF) {
            XMPMetaImpl xmp = ParseRDF.parse((Node)result2[0]);
            xmp.setPacketHeader((String)result2[2]);
            if (!options.getOmitNormalization()) {
                return XMPNormalizer.process(xmp, options);
            }
            return xmp;
        }
        return new XMPMetaImpl();
    }

    private static Document parseXml(Object input2, ParseOptions options) throws XMPException {
        if (input2 instanceof InputStream) {
            return XMPMetaParser.parseXmlFromInputStream((InputStream)input2, options);
        }
        if (input2 instanceof byte[]) {
            return XMPMetaParser.parseXmlFromBytebuffer(new ByteBuffer((byte[])input2), options);
        }
        return XMPMetaParser.parseXmlFromString((String)input2, options);
    }

    private static Document parseXmlFromInputStream(InputStream stream, ParseOptions options) throws XMPException {
        if (!options.getAcceptLatin1() && !options.getFixControlChars()) {
            return XMPMetaParser.parseInputSource(new InputSource(stream));
        }
        try {
            ByteBuffer buffer = new ByteBuffer(stream);
            return XMPMetaParser.parseXmlFromBytebuffer(buffer, options);
        }
        catch (IOException e) {
            throw new XMPException("Error reading the XML-file", 204, e);
        }
    }

    private static Document parseXmlFromBytebuffer(ByteBuffer buffer, ParseOptions options) throws XMPException {
        InputSource source = new InputSource(buffer.getByteStream());
        try {
            return XMPMetaParser.parseInputSource(source);
        }
        catch (XMPException e) {
            if (e.getErrorCode() == 201 || e.getErrorCode() == 204) {
                if (options.getAcceptLatin1()) {
                    buffer = Latin1Converter.convert(buffer);
                }
                if (options.getFixControlChars()) {
                    try {
                        String encoding = buffer.getEncoding();
                        FixASCIIControlsReader fixReader = new FixASCIIControlsReader(new InputStreamReader(buffer.getByteStream(), encoding));
                        return XMPMetaParser.parseInputSource(new InputSource(fixReader));
                    }
                    catch (UnsupportedEncodingException e1) {
                        throw new XMPException("Unsupported Encoding", 9, e);
                    }
                }
                source = new InputSource(buffer.getByteStream());
                return XMPMetaParser.parseInputSource(source);
            }
            throw e;
        }
    }

    private static Document parseXmlFromString(String input2, ParseOptions options) throws XMPException {
        InputSource source = new InputSource(new StringReader(input2));
        try {
            return XMPMetaParser.parseInputSource(source);
        }
        catch (XMPException e) {
            if (e.getErrorCode() == 201 && options.getFixControlChars()) {
                source = new InputSource(new FixASCIIControlsReader(new StringReader(input2)));
                return XMPMetaParser.parseInputSource(source);
            }
            throw e;
        }
    }

    private static Document parseInputSource(InputSource source) throws XMPException {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            return builder.parse(source);
        }
        catch (SAXException e) {
            throw new XMPException("XML parsing failure", 201, e);
        }
        catch (ParserConfigurationException e) {
            throw new XMPException("XML Parser not correctly configured", 0, e);
        }
        catch (IOException e) {
            throw new XMPException("Error reading the XML-file", 204, e);
        }
    }

    private static Object[] findRootNode(Node root2, boolean xmpmetaRequired, Object[] result2) {
        NodeList children = root2.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            root2 = children.item(i);
            if (7 == root2.getNodeType() && "xpacket".equals(((ProcessingInstruction)root2).getTarget())) {
                if (result2 == null) continue;
                result2[2] = ((ProcessingInstruction)root2).getData();
                continue;
            }
            if (3 == root2.getNodeType() || 7 == root2.getNodeType()) continue;
            String rootNS = root2.getNamespaceURI();
            String rootLocal = root2.getLocalName();
            if (("xmpmeta".equals(rootLocal) || "xapmeta".equals(rootLocal)) && "adobe:ns:meta/".equals(rootNS)) {
                return XMPMetaParser.findRootNode(root2, false, result2);
            }
            if (!xmpmetaRequired && "RDF".equals(rootLocal) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(rootNS)) {
                if (result2 != null) {
                    result2[0] = root2;
                    result2[1] = XMP_RDF;
                }
                return result2;
            }
            Object[] newResult = XMPMetaParser.findRootNode(root2, xmpmetaRequired, result2);
            if (newResult == null) continue;
            return newResult;
        }
        return null;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return factory;
    }
}

