/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.xmp.impl;

import com.itextpdf.xmp.XMPConst;

public class Utils
implements XMPConst {
    public static final int UUID_SEGMENT_COUNT = 4;
    public static final int UUID_LENGTH = 36;
    private static boolean[] xmlNameStartChars;
    private static boolean[] xmlNameChars;

    private Utils() {
    }

    public static String normalizeLangValue(String value2) {
        if ("x-default".equals(value2)) {
            return value2;
        }
        int subTag = 1;
        StringBuffer buffer = new StringBuffer();
        block4: for (int i = 0; i < value2.length(); ++i) {
            switch (value2.charAt(i)) {
                case '-': 
                case '_': {
                    buffer.append('-');
                    ++subTag;
                    continue block4;
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    if (subTag != 2) {
                        buffer.append(Character.toLowerCase(value2.charAt(i)));
                        continue block4;
                    }
                    buffer.append(Character.toUpperCase(value2.charAt(i)));
                }
            }
        }
        return buffer.toString();
    }

    static String[] splitNameAndValue(String selector) {
        int eq2 = selector.indexOf(61);
        int pos = 1;
        if (selector.charAt(pos) == '?') {
            ++pos;
        }
        String name = selector.substring(pos, eq2);
        pos = eq2 + 1;
        char quote = selector.charAt(pos);
        ++pos;
        int end = selector.length() - 2;
        StringBuffer value2 = new StringBuffer(end - eq2);
        while (pos < end) {
            value2.append(selector.charAt(pos));
            if (selector.charAt(++pos) != quote) continue;
            ++pos;
        }
        return new String[]{name, value2.toString()};
    }

    static boolean isInternalProperty(String schema, String prop) {
        boolean isInternal = false;
        if ("http://purl.org/dc/elements/1.1/".equals(schema)) {
            if ("dc:format".equals(prop) || "dc:language".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/xap/1.0/".equals(schema)) {
            if ("xmp:BaseURL".equals(prop) || "xmp:CreatorTool".equals(prop) || "xmp:Format".equals(prop) || "xmp:Locale".equals(prop) || "xmp:MetadataDate".equals(prop) || "xmp:ModifyDate".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/pdf/1.3/".equals(schema)) {
            if ("pdf:BaseURL".equals(prop) || "pdf:Creator".equals(prop) || "pdf:ModDate".equals(prop) || "pdf:PDFVersion".equals(prop) || "pdf:Producer".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/tiff/1.0/".equals(schema)) {
            isInternal = true;
            if ("tiff:ImageDescription".equals(prop) || "tiff:Artist".equals(prop) || "tiff:Copyright".equals(prop)) {
                isInternal = false;
            }
        } else if ("http://ns.adobe.com/exif/1.0/".equals(schema)) {
            isInternal = true;
            if ("exif:UserComment".equals(prop)) {
                isInternal = false;
            }
        } else if ("http://ns.adobe.com/exif/1.0/aux/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/photoshop/1.0/".equals(schema)) {
            if ("photoshop:ICCProfile".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/camera-raw-settings/1.0/".equals(schema)) {
            if ("crs:Version".equals(prop) || "crs:RawFileName".equals(prop) || "crs:ToneCurveName".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/StockPhoto/1.0/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/mm/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/t/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/t/pg/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/g/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/g/img/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/sType/Font#".equals(schema)) {
            isInternal = true;
        }
        return isInternal;
    }

    static boolean checkUUIDFormat(String uuid) {
        boolean result2 = true;
        int delimCnt = 0;
        int delimPos = 0;
        if (uuid == null) {
            return false;
        }
        for (delimPos = 0; delimPos < uuid.length(); ++delimPos) {
            if (uuid.charAt(delimPos) != '-') continue;
            ++delimCnt;
            result2 = result2 && (delimPos == 8 || delimPos == 13 || delimPos == 18 || delimPos == 23);
        }
        return result2 && 4 == delimCnt && 36 == delimPos;
    }

    public static boolean isXMLName(String name) {
        if (name.length() > 0 && !Utils.isNameStartChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Utils.isNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLNameNS(String name) {
        if (!(name.length() <= 0 || Utils.isNameStartChar(name.charAt(0)) && name.charAt(0) != ':')) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Utils.isNameChar(name.charAt(i)) && name.charAt(i) != ':') continue;
            return false;
        }
        return true;
    }

    static boolean isControlChar(char c) {
        return (c <= '\u001f' || c == '\u007f') && c != '\t' && c != '\n' && c != '\r';
    }

    public static String escapeXML(String value2, boolean forAttribute, boolean escapeWhitespaces) {
        boolean needsEscaping = false;
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c != '<' && c != '>' && c != '&' && (!escapeWhitespaces || c != '\t' && c != '\n' && c != '\r') && (!forAttribute || c != '\"')) continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            return value2;
        }
        StringBuffer buffer = new StringBuffer(value2.length() * 4 / 3);
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (!escapeWhitespaces || c != '\t' && c != '\n' && c != '\r') {
                switch (c) {
                    case '<': {
                        buffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        break;
                    }
                    case '&': {
                        buffer.append("&amp;");
                        break;
                    }
                    case '\"': {
                        buffer.append(forAttribute ? "&quot;" : "\"");
                        break;
                    }
                    default: {
                        buffer.append(c);
                        break;
                    }
                }
                continue;
            }
            buffer.append("&#x");
            buffer.append(Integer.toHexString(c).toUpperCase());
            buffer.append(';');
        }
        return buffer.toString();
    }

    static String removeControlChars(String value2) {
        StringBuffer buffer = new StringBuffer(value2);
        for (int i = 0; i < buffer.length(); ++i) {
            if (!Utils.isControlChar(buffer.charAt(i))) continue;
            buffer.setCharAt(i, ' ');
        }
        return buffer.toString();
    }

    private static boolean isNameStartChar(char ch) {
        return ch <= '\u00ff' && xmlNameStartChars[ch] || ch >= '\u0100' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u1fff' || ch >= '\u200c' && ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\ueffff';
    }

    private static boolean isNameChar(char ch) {
        return ch <= '\u00ff' && xmlNameChars[ch] || Utils.isNameStartChar(ch) || ch >= '\u0300' && ch <= '\u036f' || ch >= '\u203f' && ch <= '\u2040';
    }

    private static void initCharTables() {
        xmlNameChars = new boolean[256];
        xmlNameStartChars = new boolean[256];
        for (int ch = 0; ch < xmlNameChars.length; ch = (int)((char)(ch + 1))) {
            Utils.xmlNameStartChars[ch] = ch == 58 || 65 <= ch && ch <= 90 || ch == 95 || 97 <= ch && ch <= 122 || 192 <= ch && ch <= 214 || 216 <= ch && ch <= 246 || 248 <= ch && ch <= 255;
            Utils.xmlNameChars[ch] = xmlNameStartChars[ch] || ch == 45 || ch == 46 || 48 <= ch && ch <= 57 || ch == 183;
        }
    }

    static {
        Utils.initCharTables();
    }
}

