/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.xmp.impl;

import com.itextpdf.xmp.XMPDateTime;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.impl.ParseState;
import com.itextpdf.xmp.impl.XMPDateTimeImpl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.SimpleTimeZone;

public final class ISO8601Converter {
    private ISO8601Converter() {
    }

    public static XMPDateTime parse(String iso8601String) throws XMPException {
        return ISO8601Converter.parse(iso8601String, new XMPDateTimeImpl());
    }

    public static XMPDateTime parse(String iso8601String, XMPDateTime binValue) throws XMPException {
        if (iso8601String == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        if (iso8601String.length() == 0) {
            return binValue;
        }
        ParseState input2 = new ParseState(iso8601String);
        if (input2.ch(0) == '-') {
            input2.skip();
        }
        int value2 = input2.gatherInt("Invalid year in date string", 9999);
        if (input2.hasNext() && input2.ch() != '-') {
            throw new XMPException("Invalid date string, after year", 5);
        }
        if (input2.ch(0) == '-') {
            value2 = -value2;
        }
        binValue.setYear(value2);
        if (!input2.hasNext()) {
            return binValue;
        }
        input2.skip();
        value2 = input2.gatherInt("Invalid month in date string", 12);
        if (input2.hasNext() && input2.ch() != '-') {
            throw new XMPException("Invalid date string, after month", 5);
        }
        binValue.setMonth(value2);
        if (!input2.hasNext()) {
            return binValue;
        }
        input2.skip();
        value2 = input2.gatherInt("Invalid day in date string", 31);
        if (input2.hasNext() && input2.ch() != 'T') {
            throw new XMPException("Invalid date string, after day", 5);
        }
        binValue.setDay(value2);
        if (!input2.hasNext()) {
            return binValue;
        }
        input2.skip();
        value2 = input2.gatherInt("Invalid hour in date string", 23);
        binValue.setHour(value2);
        if (!input2.hasNext()) {
            return binValue;
        }
        if (input2.ch() == ':') {
            input2.skip();
            value2 = input2.gatherInt("Invalid minute in date string", 59);
            if (input2.hasNext() && input2.ch() != ':' && input2.ch() != 'Z' && input2.ch() != '+' && input2.ch() != '-') {
                throw new XMPException("Invalid date string, after minute", 5);
            }
            binValue.setMinute(value2);
        }
        if (!input2.hasNext()) {
            return binValue;
        }
        if (input2.hasNext() && input2.ch() == ':') {
            input2.skip();
            value2 = input2.gatherInt("Invalid whole seconds in date string", 59);
            if (input2.hasNext() && input2.ch() != '.' && input2.ch() != 'Z' && input2.ch() != '+' && input2.ch() != '-') {
                throw new XMPException("Invalid date string, after whole seconds", 5);
            }
            binValue.setSecond(value2);
            if (input2.ch() == '.') {
                input2.skip();
                int digits = input2.pos();
                value2 = input2.gatherInt("Invalid fractional seconds in date string", 999999999);
                if (input2.hasNext() && input2.ch() != 'Z' && input2.ch() != '+' && input2.ch() != '-') {
                    throw new XMPException("Invalid date string, after fractional second", 5);
                }
                for (digits = input2.pos() - digits; digits > 9; --digits) {
                    value2 /= 10;
                }
                while (digits < 9) {
                    value2 *= 10;
                    ++digits;
                }
                binValue.setNanoSecond(value2);
            }
        } else if (input2.ch() != 'Z' && input2.ch() != '+' && input2.ch() != '-') {
            throw new XMPException("Invalid date string, after time", 5);
        }
        int tzSign = 0;
        int tzHour = 0;
        int tzMinute = 0;
        if (!input2.hasNext()) {
            return binValue;
        }
        if (input2.ch() == 'Z') {
            input2.skip();
        } else if (input2.hasNext()) {
            if (input2.ch() == '+') {
                tzSign = 1;
            } else if (input2.ch() == '-') {
                tzSign = -1;
            } else {
                throw new XMPException("Time zone must begin with 'Z', '+', or '-'", 5);
            }
            input2.skip();
            tzHour = input2.gatherInt("Invalid time zone hour in date string", 23);
            if (input2.hasNext()) {
                if (input2.ch() == ':') {
                    input2.skip();
                    tzMinute = input2.gatherInt("Invalid time zone minute in date string", 59);
                } else {
                    throw new XMPException("Invalid date string, after time zone hour", 5);
                }
            }
        }
        int offset = (tzHour * 3600 * 1000 + tzMinute * 60 * 1000) * tzSign;
        binValue.setTimeZone(new SimpleTimeZone(offset, ""));
        if (input2.hasNext()) {
            throw new XMPException("Invalid date string, extra chars at end", 5);
        }
        return binValue;
    }

    public static String render(XMPDateTime dateTime) {
        StringBuffer buffer = new StringBuffer();
        if (dateTime.hasDate()) {
            DecimalFormat df = new DecimalFormat("0000", new DecimalFormatSymbols(Locale.ENGLISH));
            buffer.append(df.format(dateTime.getYear()));
            if (dateTime.getMonth() == 0) {
                return buffer.toString();
            }
            df.applyPattern("'-'00");
            buffer.append(df.format(dateTime.getMonth()));
            if (dateTime.getDay() == 0) {
                return buffer.toString();
            }
            buffer.append(df.format(dateTime.getDay()));
            if (dateTime.hasTime()) {
                buffer.append('T');
                df.applyPattern("00");
                buffer.append(df.format(dateTime.getHour()));
                buffer.append(':');
                buffer.append(df.format(dateTime.getMinute()));
                if (dateTime.getSecond() != 0 || dateTime.getNanoSecond() != 0) {
                    double seconds = (double)dateTime.getSecond() + (double)dateTime.getNanoSecond() / 1.0E9;
                    df.applyPattern(":00.#########");
                    buffer.append(df.format(seconds));
                }
                if (dateTime.hasTimeZone()) {
                    long timeInMillis = dateTime.getCalendar().getTimeInMillis();
                    int offset = dateTime.getTimeZone().getOffset(timeInMillis);
                    if (offset == 0) {
                        buffer.append('Z');
                    } else {
                        int thours = offset / 3600000;
                        int tminutes = Math.abs(offset % 3600000 / 60000);
                        df.applyPattern("+00;-00");
                        buffer.append(df.format(thours));
                        df.applyPattern(":00");
                        buffer.append(df.format(tminutes));
                    }
                }
            }
        }
        return buffer.toString();
    }
}

