/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.xmp;

import com.itextpdf.xmp.XMPDateTime;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.impl.Base64;
import com.itextpdf.xmp.impl.ISO8601Converter;
import com.itextpdf.xmp.impl.XMPUtilsImpl;
import com.itextpdf.xmp.options.PropertyOptions;

public class XMPUtils {
    private XMPUtils() {
    }

    public static String catenateArrayItems(XMPMeta xmp, String schemaNS, String arrayName, String separator, String quotes, boolean allowCommas) throws XMPException {
        return XMPUtilsImpl.catenateArrayItems(xmp, schemaNS, arrayName, separator, quotes, allowCommas);
    }

    public static void separateArrayItems(XMPMeta xmp, String schemaNS, String arrayName, String catedStr, PropertyOptions arrayOptions, boolean preserveCommas) throws XMPException {
        XMPUtilsImpl.separateArrayItems(xmp, schemaNS, arrayName, catedStr, arrayOptions, preserveCommas);
    }

    public static void removeProperties(XMPMeta xmp, String schemaNS, String propName, boolean doAllProperties, boolean includeAliases) throws XMPException {
        XMPUtilsImpl.removeProperties(xmp, schemaNS, propName, doAllProperties, includeAliases);
    }

    public static void appendProperties(XMPMeta source, XMPMeta dest, boolean doAllProperties, boolean replaceOldValues) throws XMPException {
        XMPUtils.appendProperties(source, dest, doAllProperties, replaceOldValues, false);
    }

    public static void appendProperties(XMPMeta source, XMPMeta dest, boolean doAllProperties, boolean replaceOldValues, boolean deleteEmptyValues) throws XMPException {
        XMPUtilsImpl.appendProperties(source, dest, doAllProperties, replaceOldValues, deleteEmptyValues);
    }

    public static boolean convertToBoolean(String value2) throws XMPException {
        if (value2 == null || value2.length() == 0) {
            throw new XMPException("Empty convert-string", 5);
        }
        value2 = value2.toLowerCase();
        try {
            return Integer.parseInt(value2) != 0;
        }
        catch (NumberFormatException e) {
            return "true".equals(value2) || "t".equals(value2) || "on".equals(value2) || "yes".equals(value2);
        }
    }

    public static String convertFromBoolean(boolean value2) {
        return value2 ? "True" : "False";
    }

    public static int convertToInteger(String rawValue) throws XMPException {
        try {
            if (rawValue == null || rawValue.length() == 0) {
                throw new XMPException("Empty convert-string", 5);
            }
            if (rawValue.startsWith("0x")) {
                return Integer.parseInt(rawValue.substring(2), 16);
            }
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            throw new XMPException("Invalid integer string", 5);
        }
    }

    public static String convertFromInteger(int value2) {
        return String.valueOf(value2);
    }

    public static long convertToLong(String rawValue) throws XMPException {
        try {
            if (rawValue == null || rawValue.length() == 0) {
                throw new XMPException("Empty convert-string", 5);
            }
            if (rawValue.startsWith("0x")) {
                return Long.parseLong(rawValue.substring(2), 16);
            }
            return Long.parseLong(rawValue);
        }
        catch (NumberFormatException e) {
            throw new XMPException("Invalid long string", 5);
        }
    }

    public static String convertFromLong(long value2) {
        return String.valueOf(value2);
    }

    public static double convertToDouble(String rawValue) throws XMPException {
        try {
            if (rawValue == null || rawValue.length() == 0) {
                throw new XMPException("Empty convert-string", 5);
            }
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            throw new XMPException("Invalid double string", 5);
        }
    }

    public static String convertFromDouble(double value2) {
        return String.valueOf(value2);
    }

    public static XMPDateTime convertToDate(String rawValue) throws XMPException {
        if (rawValue == null || rawValue.length() == 0) {
            throw new XMPException("Empty convert-string", 5);
        }
        return ISO8601Converter.parse(rawValue);
    }

    public static String convertFromDate(XMPDateTime value2) {
        return ISO8601Converter.render(value2);
    }

    public static String encodeBase64(byte[] buffer) {
        return new String(Base64.encode(buffer));
    }

    public static byte[] decodeBase64(String base64String) throws XMPException {
        try {
            return Base64.decode(base64String.getBytes());
        }
        catch (Throwable e) {
            throw new XMPException("Invalid base64 string", 5, e);
        }
    }
}

