/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int width;
    private final int height;

    public ByteMatrix(int width, int height) {
        this.bytes = new byte[height][width];
        this.width = width;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte get(int x, int y) {
        return this.bytes[y][x];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int x, int y, byte value2) {
        this.bytes[y][x] = value2;
    }

    public void set(int x, int y, int value2) {
        this.bytes[y][x] = (byte)value2;
    }

    public void clear(byte value2) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.bytes[y][x] = value2;
            }
        }
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(2 * this.width * this.height + 2);
        for (int y = 0; y < this.height; ++y) {
            block5: for (int x = 0; x < this.width; ++x) {
                switch (this.bytes[y][x]) {
                    case 0: {
                        result2.append(" 0");
                        continue block5;
                    }
                    case 1: {
                        result2.append(" 1");
                        continue block5;
                    }
                    default: {
                        result2.append("  ");
                    }
                }
            }
            result2.append('\n');
        }
        return result2.toString();
    }
}

