/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

public final class ByteArray {
    private static final int INITIAL_SIZE = 32;
    private byte[] bytes;
    private int size;

    public ByteArray() {
        this.bytes = null;
        this.size = 0;
    }

    public ByteArray(int size2) {
        this.bytes = new byte[size2];
        this.size = size2;
    }

    public ByteArray(byte[] byteArray) {
        this.bytes = byteArray;
        this.size = this.bytes.length;
    }

    public int at(int index2) {
        return this.bytes[index2] & 0xFF;
    }

    public void set(int index2, int value2) {
        this.bytes[index2] = (byte)value2;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void appendByte(int value2) {
        if (this.size == 0 || this.size >= this.bytes.length) {
            int newSize = Math.max(32, this.size << 1);
            this.reserve(newSize);
        }
        this.bytes[this.size] = (byte)value2;
        ++this.size;
    }

    public void reserve(int capacity) {
        if (this.bytes == null || this.bytes.length < capacity) {
            byte[] newArray = new byte[capacity];
            if (this.bytes != null) {
                System.arraycopy(this.bytes, 0, newArray, 0, this.bytes.length);
            }
            this.bytes = newArray;
        }
    }

    public void set(byte[] source, int offset, int count2) {
        this.bytes = new byte[count2];
        this.size = count2;
        for (int x = 0; x < count2; ++x) {
            this.bytes[x] = source[offset + x];
        }
    }
}

