/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

public final class BitArray {
    public int[] bits;
    public final int size;

    public BitArray(int size2) {
        if (size2 < 1) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        this.size = size2;
        this.bits = BitArray.makeArray(size2);
    }

    public int getSize() {
        return this.size;
    }

    public boolean get(int i) {
        return (this.bits[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    public void set(int i) {
        int n = i >> 5;
        this.bits[n] = this.bits[n] | 1 << (i & 0x1F);
    }

    public void flip(int i) {
        int n = i >> 5;
        this.bits[n] = this.bits[n] ^ 1 << (i & 0x1F);
    }

    public void setBulk(int i, int newBits) {
        this.bits[i >> 5] = newBits;
    }

    public void clear() {
        int max2 = this.bits.length;
        for (int i = 0; i < max2; ++i) {
            this.bits[i] = 0;
        }
    }

    public boolean isRange(int start, int end, boolean value2) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start >> 5;
        int lastInt = --end >> 5;
        for (int i = firstInt; i <= lastInt; ++i) {
            int mask;
            int lastBit;
            int firstBit = i > firstInt ? 0 : start & 0x1F;
            int n = lastBit = i < lastInt ? 31 : end & 0x1F;
            if (firstBit == 0 && lastBit == 31) {
                mask = -1;
            } else {
                mask = 0;
                for (int j = firstBit; j <= lastBit; ++j) {
                    mask |= 1 << j;
                }
            }
            if ((this.bits[i] & mask) == (value2 ? mask : 0)) continue;
            return false;
        }
        return true;
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] newBits = new int[this.bits.length];
        int size2 = this.size;
        for (int i = 0; i < size2; ++i) {
            if (!this.get(size2 - i - 1)) continue;
            int n = i >> 5;
            newBits[n] = newBits[n] | 1 << (i & 0x1F);
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size2) {
        int arraySize = size2 >> 5;
        if ((size2 & 0x1F) != 0) {
            ++arraySize;
        }
        return new int[arraySize];
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(this.size);
        for (int i = 0; i < this.size; ++i) {
            if ((i & 7) == 0) {
                result2.append(' ');
            }
            result2.append(this.get(i) ? (char)'X' : '.');
        }
        return result2.toString();
    }
}

