/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.FilteredTextRenderListener;
import com.itextpdf.text.pdf.parser.MarkedContentRenderFilter;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.xml.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Set;

public class TaggedPdfReaderTool {
    protected PdfReader reader;
    protected PrintWriter out;

    public void convertToXml(PdfReader reader, OutputStream os, String charset) throws IOException {
        this.reader = reader;
        OutputStreamWriter outs = new OutputStreamWriter(os, charset);
        this.out = new PrintWriter(outs);
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary struct = catalog.getAsDict(PdfName.STRUCTTREEROOT);
        if (struct == null) {
            throw new IOException(MessageLocalization.getComposedMessage("no.structtreeroot.found", new Object[0]));
        }
        this.inspectChild(struct.getDirectObject(PdfName.K));
        this.out.flush();
        this.out.close();
    }

    public void convertToXml(PdfReader reader, OutputStream os) throws IOException {
        this.convertToXml(reader, os, Charset.defaultCharset().name());
    }

    public void inspectChild(PdfObject k) throws IOException {
        if (k == null) {
            return;
        }
        if (k instanceof PdfArray) {
            this.inspectChildArray((PdfArray)k);
        } else if (k instanceof PdfDictionary) {
            this.inspectChildDictionary((PdfDictionary)k);
        }
    }

    public void inspectChildArray(PdfArray k) throws IOException {
        if (k == null) {
            return;
        }
        for (int i = 0; i < k.size(); ++i) {
            this.inspectChild(k.getDirectObject(i));
        }
    }

    public void inspectChildDictionary(PdfDictionary k) throws IOException {
        this.inspectChildDictionary(k, false);
    }

    public void inspectChildDictionary(PdfDictionary k, boolean inspectAttributes) throws IOException {
        if (k == null) {
            return;
        }
        PdfName s2 = k.getAsName(PdfName.S);
        if (s2 != null) {
            PdfDictionary a;
            String tagN = PdfName.decodeName(s2.toString());
            String tag = TaggedPdfReaderTool.fixTagName(tagN);
            this.out.print("<");
            this.out.print(tag);
            if (inspectAttributes && (a = k.getAsDict(PdfName.A)) != null) {
                Set<PdfName> keys = a.getKeys();
                for (PdfName key : keys) {
                    this.out.print(' ');
                    PdfObject value2 = a.get(key);
                    value2 = PdfReader.getPdfObject(value2);
                    this.out.print(this.xmlName(key));
                    this.out.print("=\"");
                    this.out.print(value2.toString());
                    this.out.print("\"");
                }
            }
            this.out.print(">");
            PdfDictionary dict = k.getAsDict(PdfName.PG);
            if (dict != null) {
                this.parseTag(tagN, k.getDirectObject(PdfName.K), dict);
            }
            this.inspectChild(k.getDirectObject(PdfName.K));
            this.out.print("</");
            this.out.print(tag);
            this.out.println(">");
        } else {
            this.inspectChild(k.getDirectObject(PdfName.K));
        }
    }

    protected String xmlName(PdfName name) {
        String xmlName = name.toString().replaceFirst("/", "");
        xmlName = Character.toLowerCase(xmlName.charAt(0)) + xmlName.substring(1);
        return xmlName;
    }

    private static String fixTagName(String tag) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < tag.length(); ++k) {
            boolean nameMiddle;
            char c = tag.charAt(k);
            boolean nameStart = c == ':' || c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd';
            boolean bl = nameMiddle = c == '-' || c == '.' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040' || nameStart;
            if (k == 0) {
                if (!nameStart) {
                    c = '_';
                }
            } else if (!nameMiddle) {
                c = '-';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void parseTag(String tag, PdfObject object, PdfDictionary page) throws IOException {
        if (object instanceof PdfNumber) {
            PdfNumber mcid = (PdfNumber)object;
            MarkedContentRenderFilter filter2 = new MarkedContentRenderFilter(mcid.intValue());
            SimpleTextExtractionStrategy strategy = new SimpleTextExtractionStrategy();
            FilteredTextRenderListener listener = new FilteredTextRenderListener(strategy, filter2);
            PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener);
            processor.processContent(PdfReader.getPageContent(page), page.getAsDict(PdfName.RESOURCES));
            this.out.print(XMLUtil.escapeXML(listener.getResultantText(), true));
        } else if (object instanceof PdfArray) {
            PdfArray arr = (PdfArray)object;
            int n = arr.size();
            for (int i = 0; i < n; ++i) {
                this.parseTag(tag, arr.getPdfObject(i), page);
                if (i >= n - 1) continue;
                this.out.println();
            }
        } else if (object instanceof PdfDictionary) {
            PdfDictionary mcr = (PdfDictionary)object;
            this.parseTag(tag, mcr.getDirectObject(PdfName.MCID), mcr.getAsDict(PdfName.PG));
        }
    }
}

