/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ListIterator;

public class ContentByteUtils {
    private ContentByteUtils() {
    }

    public static byte[] getContentBytesFromContentObject(PdfObject contentObject) throws IOException {
        byte[] result2;
        switch (contentObject.type()) {
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)contentObject;
                PdfObject directObject = PdfReader.getPdfObjectRelease(ref);
                result2 = ContentByteUtils.getContentBytesFromContentObject(directObject);
                break;
            }
            case 7: {
                PRStream stream = (PRStream)PdfReader.getPdfObjectRelease(contentObject);
                result2 = PdfReader.getStreamBytes(stream);
                break;
            }
            case 5: {
                ByteArrayOutputStream allBytes = new ByteArrayOutputStream();
                PdfArray contentArray = (PdfArray)contentObject;
                ListIterator<PdfObject> iter2 = contentArray.listIterator();
                while (iter2.hasNext()) {
                    PdfObject element = iter2.next();
                    allBytes.write(ContentByteUtils.getContentBytesFromContentObject(element));
                    allBytes.write(32);
                }
                result2 = allBytes.toByteArray();
                break;
            }
            default: {
                String msg = "Unable to handle Content of type " + contentObject.getClass();
                throw new IllegalStateException(msg);
            }
        }
        return result2;
    }

    public static byte[] getContentBytesForPage(PdfReader reader, int pageNum) throws IOException {
        PdfDictionary pageDictionary = reader.getPageN(pageNum);
        PdfObject contentObject = pageDictionary.get(PdfName.CONTENTS);
        if (contentObject == null) {
            return new byte[0];
        }
        byte[] contentBytes = ContentByteUtils.getContentBytesFromContentObject(contentObject);
        return contentBytes;
    }
}

