/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.cmaps;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.fonts.cmaps.AbstractCMap;
import com.itextpdf.text.pdf.fonts.cmaps.CidLocation;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMapParserEx {
    private static final PdfName CMAPNAME = new PdfName("CMapName");
    private static final String DEF = "def";
    private static final String ENDCIDRANGE = "endcidrange";
    private static final String ENDCIDCHAR = "endcidchar";
    private static final String ENDBFRANGE = "endbfrange";
    private static final String ENDBFCHAR = "endbfchar";
    private static final String USECMAP = "usecmap";
    private static final int MAXLEVEL = 10;

    public static void parseCid(String cmapName, AbstractCMap cmap, CidLocation location) throws IOException {
        CMapParserEx.parseCid(cmapName, cmap, location, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCid(String cmapName, AbstractCMap cmap, CidLocation location, int level) throws IOException {
        if (level >= 10) {
            return;
        }
        PRTokeniser inp = location.getLocation(cmapName);
        try {
            ArrayList<PdfObject> list2 = new ArrayList<PdfObject>();
            PdfContentParser cp = new PdfContentParser(inp);
            int maxExc = 50;
            block7: while (true) {
                try {
                    cp.parse(list2);
                }
                catch (Exception ex) {
                    if (--maxExc >= 0) continue;
                    break;
                }
                if (list2.isEmpty()) {
                    break;
                }
                String last2 = list2.get(list2.size() - 1).toString();
                if (level == 0 && list2.size() == 3 && last2.equals(DEF)) {
                    PdfObject key = list2.get(0);
                    if (PdfName.REGISTRY.equals(key)) {
                        cmap.setRegistry(list2.get(1).toString());
                        continue;
                    }
                    if (PdfName.ORDERING.equals(key)) {
                        cmap.setOrdering(list2.get(1).toString());
                        continue;
                    }
                    if (CMAPNAME.equals(key)) {
                        cmap.setName(list2.get(1).toString());
                        continue;
                    }
                    if (!PdfName.SUPPLEMENT.equals(key)) continue;
                    try {
                        cmap.setSupplement(((PdfNumber)list2.get(1)).intValue());
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if ((last2.equals(ENDCIDCHAR) || last2.equals(ENDBFCHAR)) && list2.size() >= 3) {
                    int lmax = list2.size() - 2;
                    int k = 0;
                    while (true) {
                        if (k >= lmax) continue block7;
                        if (list2.get(k) instanceof PdfString) {
                            cmap.addChar((PdfString)list2.get(k), list2.get(k + 1));
                        }
                        k += 2;
                    }
                }
                if ((last2.equals(ENDCIDRANGE) || last2.equals(ENDBFRANGE)) && list2.size() >= 4) {
                    int lmax = list2.size() - 3;
                    int k = 0;
                    while (true) {
                        if (k >= lmax) continue block7;
                        if (list2.get(k) instanceof PdfString && list2.get(k + 1) instanceof PdfString) {
                            cmap.addRange((PdfString)list2.get(k), (PdfString)list2.get(k + 1), list2.get(k + 2));
                        }
                        k += 3;
                    }
                }
                if (!last2.equals(USECMAP) || list2.size() != 2 || !(list2.get(0) instanceof PdfName)) continue;
                CMapParserEx.parseCid(PdfName.decodeName(list2.get(0).toString()), cmap, location, level + 1);
            }
        }
        finally {
            inp.close();
        }
    }

    private static void encodeSequence(int size2, byte[] seqs, char cid, ArrayList<char[]> planes) {
        int one;
        --size2;
        int nextPlane = 0;
        for (int idx = 0; idx < size2; ++idx) {
            int one2;
            char[] plane = planes.get(nextPlane);
            char c = plane[one2 = seqs[idx] & 0xFF];
            if (c != '\u0000' && (c & 0x8000) == 0) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("inconsistent.mapping", new Object[0]));
            }
            if (c == '\u0000') {
                planes.add(new char[256]);
                plane[one2] = c = (char)(planes.size() - 1 | 0x8000);
            }
            nextPlane = c & Short.MAX_VALUE;
        }
        char[] plane = planes.get(nextPlane);
        char c = plane[one = seqs[size2] & 0xFF];
        if ((c & 0x8000) != 0) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("inconsistent.mapping", new Object[0]));
        }
        plane[one] = cid;
    }
}

