/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.events;

import com.itextpdf.text.Document;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfPageEventForwarder
implements PdfPageEvent {
    protected ArrayList<PdfPageEvent> events = new ArrayList();

    public void addPageEvent(PdfPageEvent event) {
        this.events.add(event);
    }

    public void onOpenDocument(PdfWriter writer, Document document2) {
        for (PdfPageEvent event : this.events) {
            event.onOpenDocument(writer, document2);
        }
    }

    public void onStartPage(PdfWriter writer, Document document2) {
        for (PdfPageEvent event : this.events) {
            event.onStartPage(writer, document2);
        }
    }

    public void onEndPage(PdfWriter writer, Document document2) {
        for (PdfPageEvent event : this.events) {
            event.onEndPage(writer, document2);
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document2) {
        for (PdfPageEvent event : this.events) {
            event.onCloseDocument(writer, document2);
        }
    }

    public void onParagraph(PdfWriter writer, Document document2, float paragraphPosition) {
        for (PdfPageEvent event : this.events) {
            event.onParagraph(writer, document2, paragraphPosition);
        }
    }

    public void onParagraphEnd(PdfWriter writer, Document document2, float paragraphPosition) {
        for (PdfPageEvent event : this.events) {
            event.onParagraphEnd(writer, document2, paragraphPosition);
        }
    }

    public void onChapter(PdfWriter writer, Document document2, float paragraphPosition, Paragraph title) {
        for (PdfPageEvent event : this.events) {
            event.onChapter(writer, document2, paragraphPosition, title);
        }
    }

    public void onChapterEnd(PdfWriter writer, Document document2, float position) {
        for (PdfPageEvent event : this.events) {
            event.onChapterEnd(writer, document2, position);
        }
    }

    public void onSection(PdfWriter writer, Document document2, float paragraphPosition, int depth, Paragraph title) {
        for (PdfPageEvent event : this.events) {
            event.onSection(writer, document2, paragraphPosition, depth, title);
        }
    }

    public void onSectionEnd(PdfWriter writer, Document document2, float position) {
        for (PdfPageEvent event : this.events) {
            event.onSectionEnd(writer, document2, position);
        }
    }

    public void onGenericTag(PdfWriter writer, Document document2, Rectangle rect, String text2) {
        Iterator<PdfPageEvent> i$ = this.events.iterator();
        while (i$.hasNext()) {
            PdfPageEvent element;
            PdfPageEvent event = element = i$.next();
            event.onGenericTag(writer, document2, rect, text2);
        }
    }
}

