/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import com.itextpdf.text.error_messages.MessageLocalization;

public class TIFFLZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    byte[] uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int dstIndex;
    int w;
    int h;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public TIFFLZWDecoder(int w, int predictor, int samplesPerPixel) {
        this.w = w;
        this.predictor = predictor;
        this.samplesPerPixel = samplesPerPixel;
    }

    public byte[] decode(byte[] data2, byte[] uncompData, int h) {
        int code;
        if (data2[0] == 0 && data2[1] == 1) {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("tiff.5.0.style.lzw.codes.are.not.supported", new Object[0]));
        }
        this.initializeStringTable();
        this.data = data2;
        this.h = h;
        this.uncompData = uncompData;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.dstIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int oldCode = 0;
        while ((code = this.getNextCode()) != 257 && this.dstIndex < uncompData.length) {
            byte[] string2;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode();
                if (code == 257) break;
                this.writeString(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                string2 = this.stringTable[code];
                this.writeString(string2);
                this.addStringToTable(this.stringTable[oldCode], string2[0]);
                oldCode = code;
                continue;
            }
            string2 = this.stringTable[oldCode];
            string2 = this.composeString(string2, string2[0]);
            this.writeString(string2);
            this.addStringToTable(string2);
            oldCode = code;
        }
        if (this.predictor == 2) {
            for (int j = 0; j < h; ++j) {
                int count2 = this.samplesPerPixel * (j * this.w + 1);
                for (int i = this.samplesPerPixel; i < this.w * this.samplesPerPixel; ++i) {
                    int n = count2;
                    uncompData[n] = (byte)(uncompData[n] + uncompData[count2 - this.samplesPerPixel]);
                    ++count2;
                }
            }
        }
        return uncompData;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] string2) {
        int max2 = this.uncompData.length - this.dstIndex;
        if (string2.length < max2) {
            max2 = string2.length;
        }
        System.arraycopy(string2, 0, this.uncompData, this.dstIndex, max2);
        this.dstIndex += max2;
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string2 = new byte[length + 1];
        System.arraycopy(oldString, 0, string2, 0, length);
        string2[length] = newString;
        this.stringTable[this.tableIndex++] = string2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] string2) {
        this.stringTable[this.tableIndex++] = string2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string2 = new byte[length + 1];
        System.arraycopy(oldString, 0, string2, 0, length);
        string2[length] = newString;
        return string2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 257;
        }
    }
}

