/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIFFField
implements Comparable<TIFFField>,
Serializable {
    private static final long serialVersionUID = 9088332901412823834L;
    public static final int TIFF_BYTE = 1;
    public static final int TIFF_ASCII = 2;
    public static final int TIFF_SHORT = 3;
    public static final int TIFF_LONG = 4;
    public static final int TIFF_RATIONAL = 5;
    public static final int TIFF_SBYTE = 6;
    public static final int TIFF_UNDEFINED = 7;
    public static final int TIFF_SSHORT = 8;
    public static final int TIFF_SLONG = 9;
    public static final int TIFF_SRATIONAL = 10;
    public static final int TIFF_FLOAT = 11;
    public static final int TIFF_DOUBLE = 12;
    int tag;
    int type;
    int count;
    Object data;

    TIFFField() {
    }

    public TIFFField(int tag, int type, int count2, Object data2) {
        this.tag = tag;
        this.type = type;
        this.count = count2;
        this.data = data2;
    }

    public int getTag() {
        return this.tag;
    }

    public int getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getAsBytes() {
        return (byte[])this.data;
    }

    public char[] getAsChars() {
        return (char[])this.data;
    }

    public short[] getAsShorts() {
        return (short[])this.data;
    }

    public int[] getAsInts() {
        return (int[])this.data;
    }

    public long[] getAsLongs() {
        return (long[])this.data;
    }

    public float[] getAsFloats() {
        return (float[])this.data;
    }

    public double[] getAsDoubles() {
        return (double[])this.data;
    }

    public int[][] getAsSRationals() {
        return (int[][])this.data;
    }

    public long[][] getAsRationals() {
        return (long[][])this.data;
    }

    public int getAsInt(int index2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index2];
            }
            case 3: {
                return ((char[])this.data)[index2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index2];
            }
            case 9: {
                return ((int[])this.data)[index2];
            }
        }
        throw new ClassCastException();
    }

    public long getAsLong(int index2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index2];
            }
            case 3: {
                return ((char[])this.data)[index2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index2];
            }
            case 9: {
                return ((int[])this.data)[index2];
            }
            case 4: {
                return ((long[])this.data)[index2];
            }
        }
        throw new ClassCastException();
    }

    public float getAsFloat(int index2) {
        switch (this.type) {
            case 1: {
                return ((byte[])this.data)[index2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index2];
            }
            case 3: {
                return ((char[])this.data)[index2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index2];
            }
            case 9: {
                return ((int[])this.data)[index2];
            }
            case 4: {
                return ((long[])this.data)[index2];
            }
            case 11: {
                return ((float[])this.data)[index2];
            }
            case 12: {
                return (float)((double[])this.data)[index2];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index2);
                return (float)((double)ivalue[0] / (double)ivalue[1]);
            }
            case 5: {
                long[] lvalue = this.getAsRational(index2);
                return (float)((double)lvalue[0] / (double)lvalue[1]);
            }
        }
        throw new ClassCastException();
    }

    public double getAsDouble(int index2) {
        switch (this.type) {
            case 1: {
                return ((byte[])this.data)[index2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index2];
            }
            case 3: {
                return ((char[])this.data)[index2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index2];
            }
            case 9: {
                return ((int[])this.data)[index2];
            }
            case 4: {
                return ((long[])this.data)[index2];
            }
            case 11: {
                return ((float[])this.data)[index2];
            }
            case 12: {
                return ((double[])this.data)[index2];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index2);
                return (double)ivalue[0] / (double)ivalue[1];
            }
            case 5: {
                long[] lvalue = this.getAsRational(index2);
                return (double)lvalue[0] / (double)lvalue[1];
            }
        }
        throw new ClassCastException();
    }

    public String getAsString(int index2) {
        return ((String[])this.data)[index2];
    }

    public int[] getAsSRational(int index2) {
        return ((int[][])this.data)[index2];
    }

    public long[] getAsRational(int index2) {
        if (this.type == 4) {
            return this.getAsLongs();
        }
        return ((long[][])this.data)[index2];
    }

    @Override
    public int compareTo(TIFFField o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        int oTag = o.getTag();
        if (this.tag < oTag) {
            return -1;
        }
        if (this.tag > oTag) {
            return 1;
        }
        return 0;
    }
}

