/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import java.io.PrintStream;

public class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strNxt_ = new short[4096];
    short[] strHsh_;
    short numStrings_;
    int[] strLen_ = new int[4096];

    public LZWStringTable() {
        this.strHsh_ = new short[9973];
    }

    public int AddCharString(short index2, byte b) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int hshidx = LZWStringTable.Hash(index2, b);
        while (this.strHsh_[hshidx] != -1) {
            hshidx = (hshidx + 2039) % 9973;
        }
        this.strHsh_[hshidx] = this.numStrings_;
        this.strChr_[this.numStrings_] = b;
        if (index2 == -1) {
            this.strNxt_[this.numStrings_] = -1;
            this.strLen_[this.numStrings_] = 1;
        } else {
            this.strNxt_[this.numStrings_] = index2;
            this.strLen_[this.numStrings_] = this.strLen_[index2] + 1;
        }
        short s2 = this.numStrings_;
        this.numStrings_ = (short)(s2 + 1);
        return s2;
    }

    public short FindCharString(short index2, byte b) {
        short nxtidx;
        if (index2 == -1) {
            return (short)(b & 0xFF);
        }
        int hshidx = LZWStringTable.Hash(index2, b);
        while ((nxtidx = this.strHsh_[hshidx]) != -1) {
            if (this.strNxt_[nxtidx] == index2 && this.strChr_[nxtidx] == b) {
                return nxtidx;
            }
            hshidx = (hshidx + 2039) % 9973;
        }
        return -1;
    }

    public void ClearTable(int codesize) {
        this.numStrings_ = 0;
        for (int q = 0; q < 9973; ++q) {
            this.strHsh_[q] = -1;
        }
        int w = (1 << codesize) + 2;
        for (int q = 0; q < w; ++q) {
            this.AddCharString((short)-1, (byte)q);
        }
    }

    public static int Hash(short index2, byte lastbyte) {
        return (((short)(lastbyte << 8) ^ index2) & 0xFFFF) % 9973;
    }

    public int expandCode(byte[] buf, int offset, short code, int skipHead) {
        if (offset == -2 && skipHead == 1) {
            skipHead = 0;
        }
        if (code == -1 || skipHead == this.strLen_[code]) {
            return 0;
        }
        int bufSpace = buf.length - offset;
        int codeLen = this.strLen_[code] - skipHead;
        int expandLen = bufSpace > codeLen ? codeLen : bufSpace;
        int skipTail = codeLen - expandLen;
        int idx = offset + expandLen;
        while (idx > offset && code != -1) {
            if (--skipTail < 0) {
                buf[--idx] = this.strChr_[code];
            }
            code = this.strNxt_[code];
        }
        if (codeLen > expandLen) {
            return -expandLen;
        }
        return expandLen;
    }

    public void dump(PrintStream out) {
        for (int i = 258; i < this.numStrings_; ++i) {
            out.println(" strNxt_[" + i + "] = " + this.strNxt_[i] + " strChr_ " + Integer.toHexString(this.strChr_[i] & 0xFF) + " strLen_ " + Integer.toHexString(this.strLen_[i]));
        }
    }
}

