/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.SimpleNamedDestination;
import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.text.xml.simpleparser.IanaEncodings;
import com.itextpdf.text.xml.simpleparser.SimpleXMLDocHandler;
import com.itextpdf.text.xml.simpleparser.SimpleXMLParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleBookmark
implements SimpleXMLDocHandler {
    private ArrayList<HashMap<String, Object>> topList;
    private final Stack<HashMap<String, Object>> attr = new Stack();

    private SimpleBookmark() {
    }

    private static List<HashMap<String, Object>> bookmarkDepth(PdfReader reader, PdfDictionary outline, IntHashtable pages, boolean processCurrentOutlineOnly) {
        ArrayList<HashMap<String, Object>> list2 = new ArrayList<HashMap<String, Object>>();
        while (outline != null) {
            PdfNumber count2;
            PdfNumber style;
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            PdfString title = (PdfString)PdfReader.getPdfObjectRelease(outline.get(PdfName.TITLE));
            map2.put("Title", title.toUnicodeString());
            PdfArray color = (PdfArray)PdfReader.getPdfObjectRelease(outline.get(PdfName.C));
            if (color != null && color.size() == 3) {
                ByteBuffer out = new ByteBuffer();
                out.append(color.getAsNumber(0).floatValue()).append(' ');
                out.append(color.getAsNumber(1).floatValue()).append(' ');
                out.append(color.getAsNumber(2).floatValue());
                map2.put("Color", PdfEncodings.convertToString(out.toByteArray(), null));
            }
            if ((style = (PdfNumber)PdfReader.getPdfObjectRelease(outline.get(PdfName.F))) != null) {
                int f = style.intValue();
                String s2 = "";
                if ((f & 1) != 0) {
                    s2 = s2 + "italic ";
                }
                if ((f & 2) != 0) {
                    s2 = s2 + "bold ";
                }
                if ((s2 = s2.trim()).length() != 0) {
                    map2.put("Style", s2);
                }
            }
            if ((count2 = (PdfNumber)PdfReader.getPdfObjectRelease(outline.get(PdfName.COUNT))) != null && count2.intValue() < 0) {
                map2.put("Open", "false");
            }
            try {
                PdfObject dest = PdfReader.getPdfObjectRelease(outline.get(PdfName.DEST));
                if (dest != null) {
                    SimpleBookmark.mapGotoBookmark(map2, dest, pages);
                } else {
                    PdfDictionary action = (PdfDictionary)PdfReader.getPdfObjectRelease(outline.get(PdfName.A));
                    if (action != null) {
                        PdfObject file;
                        if (PdfName.GOTO.equals(PdfReader.getPdfObjectRelease(action.get(PdfName.S)))) {
                            dest = PdfReader.getPdfObjectRelease(action.get(PdfName.D));
                            if (dest != null) {
                                SimpleBookmark.mapGotoBookmark(map2, dest, pages);
                            }
                        } else if (PdfName.URI.equals(PdfReader.getPdfObjectRelease(action.get(PdfName.S)))) {
                            map2.put("Action", "URI");
                            map2.put("URI", ((PdfString)PdfReader.getPdfObjectRelease(action.get(PdfName.URI))).toUnicodeString());
                        } else if (PdfName.JAVASCRIPT.equals(PdfReader.getPdfObjectRelease(action.get(PdfName.S)))) {
                            map2.put("Action", "JS");
                            map2.put("Code", PdfReader.getPdfObjectRelease(action.get(PdfName.JS)).toString());
                        } else if (PdfName.GOTOR.equals(PdfReader.getPdfObjectRelease(action.get(PdfName.S)))) {
                            PdfObject newWindow;
                            dest = PdfReader.getPdfObjectRelease(action.get(PdfName.D));
                            if (dest != null) {
                                if (dest.isString()) {
                                    map2.put("Named", dest.toString());
                                } else if (dest.isName()) {
                                    map2.put("NamedN", PdfName.decodeName(dest.toString()));
                                } else if (dest.isArray()) {
                                    PdfArray arr = (PdfArray)dest;
                                    StringBuffer s3 = new StringBuffer();
                                    s3.append(arr.getPdfObject(0).toString());
                                    s3.append(' ').append(arr.getPdfObject(1).toString());
                                    for (int k = 2; k < arr.size(); ++k) {
                                        s3.append(' ').append(arr.getPdfObject(k).toString());
                                    }
                                    map2.put("Page", s3.toString());
                                }
                            }
                            map2.put("Action", "GoToR");
                            file = PdfReader.getPdfObjectRelease(action.get(PdfName.F));
                            if (file != null) {
                                if (file.isString()) {
                                    map2.put("File", ((PdfString)file).toUnicodeString());
                                } else if (file.isDictionary() && (file = PdfReader.getPdfObject(((PdfDictionary)file).get(PdfName.F))).isString()) {
                                    map2.put("File", ((PdfString)file).toUnicodeString());
                                }
                            }
                            if ((newWindow = PdfReader.getPdfObjectRelease(action.get(PdfName.NEWWINDOW))) != null) {
                                map2.put("NewWindow", newWindow.toString());
                            }
                        } else if (PdfName.LAUNCH.equals(PdfReader.getPdfObjectRelease(action.get(PdfName.S)))) {
                            map2.put("Action", "Launch");
                            file = PdfReader.getPdfObjectRelease(action.get(PdfName.F));
                            if (file == null) {
                                file = PdfReader.getPdfObjectRelease(action.get(PdfName.WIN));
                            }
                            if (file != null) {
                                if (file.isString()) {
                                    map2.put("File", ((PdfString)file).toUnicodeString());
                                } else if (file.isDictionary() && (file = PdfReader.getPdfObjectRelease(((PdfDictionary)file).get(PdfName.F))).isString()) {
                                    map2.put("File", ((PdfString)file).toUnicodeString());
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            PdfDictionary first = (PdfDictionary)PdfReader.getPdfObjectRelease(outline.get(PdfName.FIRST));
            if (first != null) {
                map2.put("Kids", SimpleBookmark.bookmarkDepth(reader, first, pages, false));
            }
            list2.add(map2);
            if (!processCurrentOutlineOnly) {
                outline = (PdfDictionary)PdfReader.getPdfObjectRelease(outline.get(PdfName.NEXT));
                continue;
            }
            outline = null;
        }
        return list2;
    }

    private static void mapGotoBookmark(HashMap<String, Object> map2, PdfObject dest, IntHashtable pages) {
        if (dest.isString()) {
            map2.put("Named", dest.toString());
        } else if (dest.isName()) {
            map2.put("Named", PdfName.decodeName(dest.toString()));
        } else if (dest.isArray()) {
            map2.put("Page", SimpleBookmark.makeBookmarkParam((PdfArray)dest, pages));
        }
        map2.put("Action", "GoTo");
    }

    private static String makeBookmarkParam(PdfArray dest, IntHashtable pages) {
        StringBuffer s2 = new StringBuffer();
        PdfObject obj = dest.getPdfObject(0);
        if (obj.isNumber()) {
            s2.append(((PdfNumber)obj).intValue() + 1);
        } else {
            s2.append(pages.get(SimpleBookmark.getNumber((PdfIndirectReference)obj)));
        }
        s2.append(' ').append(dest.getPdfObject(1).toString().substring(1));
        for (int k = 2; k < dest.size(); ++k) {
            s2.append(' ').append(dest.getPdfObject(k).toString());
        }
        return s2.toString();
    }

    private static int getNumber(PdfIndirectReference indirect) {
        PdfDictionary pdfObj = (PdfDictionary)PdfReader.getPdfObjectRelease(indirect);
        if (pdfObj.contains(PdfName.TYPE) && pdfObj.get(PdfName.TYPE).equals(PdfName.PAGES) && pdfObj.contains(PdfName.KIDS)) {
            PdfArray kids = (PdfArray)pdfObj.get(PdfName.KIDS);
            indirect = (PdfIndirectReference)kids.getPdfObject(0);
        }
        return indirect.getNumber();
    }

    public static List<HashMap<String, Object>> getBookmark(PdfReader reader) {
        PdfDictionary catalog = reader.getCatalog();
        PdfObject obj = PdfReader.getPdfObjectRelease(catalog.get(PdfName.OUTLINES));
        if (obj == null || !obj.isDictionary()) {
            return null;
        }
        PdfDictionary outlines = (PdfDictionary)obj;
        return SimpleBookmark.getBookmark(reader, outlines, false);
    }

    public static List<HashMap<String, Object>> getBookmark(PdfReader reader, PdfDictionary outline, boolean includeRoot) {
        PdfDictionary catalog = reader.getCatalog();
        if (outline == null) {
            return null;
        }
        IntHashtable pages = new IntHashtable();
        int numPages = reader.getNumberOfPages();
        for (int k = 1; k <= numPages; ++k) {
            pages.put(reader.getPageOrigRef(k).getNumber(), k);
            reader.releasePage(k);
        }
        if (includeRoot) {
            return SimpleBookmark.bookmarkDepth(reader, outline, pages, true);
        }
        return SimpleBookmark.bookmarkDepth(reader, (PdfDictionary)PdfReader.getPdfObjectRelease(outline.get(PdfName.FIRST)), pages, false);
    }

    public static void eliminatePages(List<HashMap<String, Object>> list2, int[] pageRange) {
        if (list2 == null) {
            return;
        }
        ListIterator<HashMap<String, Object>> it = list2.listIterator();
        while (it.hasNext()) {
            List kids;
            String page;
            HashMap map2 = (HashMap)it.next();
            boolean hit = false;
            if ("GoTo".equals(map2.get("Action")) && (page = (String)map2.get("Page")) != null) {
                int idx = (page = page.trim()).indexOf(32);
                int pageNum = idx < 0 ? Integer.parseInt(page) : Integer.parseInt(page.substring(0, idx));
                int len = pageRange.length & 0xFFFFFFFE;
                for (int k = 0; k < len; k += 2) {
                    if (pageNum < pageRange[k] || pageNum > pageRange[k + 1]) continue;
                    hit = true;
                    break;
                }
            }
            if ((kids = (List)map2.get("Kids")) != null) {
                SimpleBookmark.eliminatePages(kids, pageRange);
                if (kids.isEmpty()) {
                    map2.remove("Kids");
                    kids = null;
                }
            }
            if (!hit) continue;
            if (kids == null) {
                it.remove();
                continue;
            }
            map2.remove("Action");
            map2.remove("Page");
            map2.remove("Named");
        }
    }

    public static void shiftPageNumbers(List<HashMap<String, Object>> list2, int pageShift, int[] pageRange) {
        if (list2 == null) {
            return;
        }
        ListIterator<HashMap<String, Object>> it = list2.listIterator();
        while (it.hasNext()) {
            List kids;
            String page;
            HashMap map2 = (HashMap)it.next();
            if ("GoTo".equals(map2.get("Action")) && (page = (String)map2.get("Page")) != null) {
                int idx = (page = page.trim()).indexOf(32);
                int pageNum = idx < 0 ? Integer.parseInt(page) : Integer.parseInt(page.substring(0, idx));
                boolean hit = false;
                if (pageRange == null) {
                    hit = true;
                } else {
                    int len = pageRange.length & 0xFFFFFFFE;
                    for (int k = 0; k < len; k += 2) {
                        if (pageNum < pageRange[k] || pageNum > pageRange[k + 1]) continue;
                        hit = true;
                        break;
                    }
                }
                if (hit) {
                    page = idx < 0 ? Integer.toString(pageNum + pageShift) : pageNum + pageShift + page.substring(idx);
                }
                map2.put("Page", page);
            }
            if ((kids = (List)map2.get("Kids")) == null) continue;
            SimpleBookmark.shiftPageNumbers(kids, pageShift, pageRange);
        }
    }

    static void createOutlineAction(PdfDictionary outline, HashMap<String, Object> map2, PdfWriter writer, boolean namedAsNames) {
        try {
            String file;
            String action = (String)map2.get("Action");
            if ("GoTo".equals(action)) {
                String p = (String)map2.get("Named");
                if (p != null) {
                    if (namedAsNames) {
                        outline.put(PdfName.DEST, new PdfName(p));
                    } else {
                        outline.put(PdfName.DEST, new PdfString(p, null));
                    }
                } else {
                    p = (String)map2.get("Page");
                    if (p != null) {
                        PdfArray ar = new PdfArray();
                        StringTokenizer tk = new StringTokenizer(p);
                        int n = Integer.parseInt(tk.nextToken());
                        ar.add(writer.getPageReference(n));
                        if (!tk.hasMoreTokens()) {
                            ar.add(PdfName.XYZ);
                            ar.add(new float[]{0.0f, 10000.0f, 0.0f});
                        } else {
                            String fn = tk.nextToken();
                            if (fn.startsWith("/")) {
                                fn = fn.substring(1);
                            }
                            ar.add(new PdfName(fn));
                            for (int k = 0; k < 4 && tk.hasMoreTokens(); ++k) {
                                fn = tk.nextToken();
                                if (fn.equals("null")) {
                                    ar.add(PdfNull.PDFNULL);
                                    continue;
                                }
                                ar.add(new PdfNumber(fn));
                            }
                        }
                        outline.put(PdfName.DEST, ar);
                    }
                }
            } else if ("GoToR".equals(action)) {
                PdfDictionary dic = new PdfDictionary();
                String p = (String)map2.get("Named");
                if (p != null) {
                    dic.put(PdfName.D, new PdfString(p, null));
                } else {
                    p = (String)map2.get("NamedN");
                    if (p != null) {
                        dic.put(PdfName.D, new PdfName(p));
                    } else {
                        p = (String)map2.get("Page");
                        if (p != null) {
                            PdfArray ar = new PdfArray();
                            StringTokenizer tk = new StringTokenizer(p);
                            ar.add(new PdfNumber(tk.nextToken()));
                            if (!tk.hasMoreTokens()) {
                                ar.add(PdfName.XYZ);
                                ar.add(new float[]{0.0f, 10000.0f, 0.0f});
                            } else {
                                String fn = tk.nextToken();
                                if (fn.startsWith("/")) {
                                    fn = fn.substring(1);
                                }
                                ar.add(new PdfName(fn));
                                for (int k = 0; k < 4 && tk.hasMoreTokens(); ++k) {
                                    fn = tk.nextToken();
                                    if (fn.equals("null")) {
                                        ar.add(PdfNull.PDFNULL);
                                        continue;
                                    }
                                    ar.add(new PdfNumber(fn));
                                }
                            }
                            dic.put(PdfName.D, ar);
                        }
                    }
                }
                String file2 = (String)map2.get("File");
                if (dic.size() > 0 && file2 != null) {
                    dic.put(PdfName.S, PdfName.GOTOR);
                    dic.put(PdfName.F, new PdfString(file2));
                    String nw = (String)map2.get("NewWindow");
                    if (nw != null) {
                        if (nw.equals("true")) {
                            dic.put(PdfName.NEWWINDOW, PdfBoolean.PDFTRUE);
                        } else if (nw.equals("false")) {
                            dic.put(PdfName.NEWWINDOW, PdfBoolean.PDFFALSE);
                        }
                    }
                    outline.put(PdfName.A, dic);
                }
            } else if ("URI".equals(action)) {
                String uri = (String)map2.get("URI");
                if (uri != null) {
                    PdfDictionary dic = new PdfDictionary();
                    dic.put(PdfName.S, PdfName.URI);
                    dic.put(PdfName.URI, new PdfString(uri));
                    outline.put(PdfName.A, dic);
                }
            } else if ("JS".equals(action)) {
                String code = (String)map2.get("Code");
                if (code != null) {
                    outline.put(PdfName.A, PdfAction.javaScript(code, writer));
                }
            } else if ("Launch".equals(action) && (file = (String)map2.get("File")) != null) {
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.S, PdfName.LAUNCH);
                dic.put(PdfName.F, new PdfString(file));
                outline.put(PdfName.A, dic);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Object[] iterateOutlines(PdfWriter writer, PdfIndirectReference parent, List<HashMap<String, Object>> kids, boolean namedAsNames) throws IOException {
        PdfIndirectReference[] refs = new PdfIndirectReference[kids.size()];
        for (int k = 0; k < refs.length; ++k) {
            refs[k] = writer.getPdfIndirectReference();
        }
        int ptr = 0;
        int count2 = 0;
        ListIterator<HashMap<String, Object>> it = kids.listIterator();
        while (it.hasNext()) {
            String style;
            HashMap map2 = (HashMap)it.next();
            Object[] lower = null;
            List subKid = (List)map2.get("Kids");
            if (subKid != null && !subKid.isEmpty()) {
                lower = SimpleBookmark.iterateOutlines(writer, refs[ptr], subKid, namedAsNames);
            }
            PdfDictionary outline = new PdfDictionary();
            ++count2;
            if (lower != null) {
                outline.put(PdfName.FIRST, (PdfIndirectReference)lower[0]);
                outline.put(PdfName.LAST, (PdfIndirectReference)lower[1]);
                int n = (Integer)lower[2];
                if ("false".equals(map2.get("Open"))) {
                    outline.put(PdfName.COUNT, new PdfNumber(-n));
                } else {
                    outline.put(PdfName.COUNT, new PdfNumber(n));
                    count2 += n;
                }
            }
            outline.put(PdfName.PARENT, parent);
            if (ptr > 0) {
                outline.put(PdfName.PREV, refs[ptr - 1]);
            }
            if (ptr < refs.length - 1) {
                outline.put(PdfName.NEXT, refs[ptr + 1]);
            }
            outline.put(PdfName.TITLE, new PdfString((String)map2.get("Title"), "UnicodeBig"));
            String color = (String)map2.get("Color");
            if (color != null) {
                try {
                    PdfArray arr = new PdfArray();
                    StringTokenizer tk = new StringTokenizer(color);
                    for (int k = 0; k < 3; ++k) {
                        float f = Float.parseFloat(tk.nextToken());
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        if (f > 1.0f) {
                            f = 1.0f;
                        }
                        arr.add(new PdfNumber(f));
                    }
                    outline.put(PdfName.C, arr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((style = (String)map2.get("Style")) != null) {
                style = style.toLowerCase();
                int bits2 = 0;
                if (style.indexOf("italic") >= 0) {
                    bits2 |= 1;
                }
                if (style.indexOf("bold") >= 0) {
                    bits2 |= 2;
                }
                if (bits2 != 0) {
                    outline.put(PdfName.F, new PdfNumber(bits2));
                }
            }
            SimpleBookmark.createOutlineAction(outline, map2, writer, namedAsNames);
            writer.addToBody((PdfObject)outline, refs[ptr]);
            ++ptr;
        }
        return new Object[]{refs[0], refs[refs.length - 1], count2};
    }

    public static void exportToXMLNode(List<HashMap<String, Object>> list2, Writer out, int indent, boolean onlyASCII) throws IOException {
        String dep = "";
        if (indent != -1) {
            for (int k = 0; k < indent; ++k) {
                dep = dep + "  ";
            }
        }
        for (HashMap<String, Object> map2 : list2) {
            String title = null;
            out.write(dep);
            out.write("<Title ");
            List kids = null;
            for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
                String key = entry2.getKey();
                if (key.equals("Title")) {
                    title = (String)entry2.getValue();
                    continue;
                }
                if (key.equals("Kids")) {
                    kids = (List)entry2.getValue();
                    continue;
                }
                out.write(key);
                out.write("=\"");
                String value2 = (String)entry2.getValue();
                if (key.equals("Named") || key.equals("NamedN")) {
                    value2 = SimpleNamedDestination.escapeBinaryString(value2);
                }
                out.write(XMLUtil.escapeXML(value2, onlyASCII));
                out.write("\" ");
            }
            out.write(">");
            if (title == null) {
                title = "";
            }
            out.write(XMLUtil.escapeXML(title, onlyASCII));
            if (kids != null) {
                out.write("\n");
                SimpleBookmark.exportToXMLNode(kids, out, indent == -1 ? indent : indent + 1, onlyASCII);
                out.write(dep);
            }
            out.write("</Title>\n");
        }
    }

    public static void exportToXML(List<HashMap<String, Object>> list2, OutputStream out, String encoding, boolean onlyASCII) throws IOException {
        String jenc = IanaEncodings.getJavaEncoding(encoding);
        BufferedWriter wrt = new BufferedWriter(new OutputStreamWriter(out, jenc));
        SimpleBookmark.exportToXML(list2, wrt, encoding, onlyASCII);
    }

    public static void exportToXML(List<HashMap<String, Object>> list2, Writer wrt, String encoding, boolean onlyASCII) throws IOException {
        wrt.write("<?xml version=\"1.0\" encoding=\"");
        wrt.write(XMLUtil.escapeXML(encoding, onlyASCII));
        wrt.write("\"?>\n<Bookmark>\n");
        SimpleBookmark.exportToXMLNode(list2, wrt, 1, onlyASCII);
        wrt.write("</Bookmark>\n");
        wrt.flush();
    }

    public static List<HashMap<String, Object>> importFromXML(InputStream in) throws IOException {
        SimpleBookmark book = new SimpleBookmark();
        SimpleXMLParser.parse((SimpleXMLDocHandler)book, in);
        return book.topList;
    }

    public static List<HashMap<String, Object>> importFromXML(Reader in) throws IOException {
        SimpleBookmark book = new SimpleBookmark();
        SimpleXMLParser.parse((SimpleXMLDocHandler)book, in);
        return book.topList;
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String tag) {
        if (tag.equals("Bookmark")) {
            if (this.attr.isEmpty()) {
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("bookmark.end.tag.out.of.place", new Object[0]));
        }
        if (!tag.equals("Title")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.end.tag.1", tag));
        }
        HashMap<String, Object> attributes = this.attr.pop();
        String title = (String)attributes.get("Title");
        attributes.put("Title", title.trim());
        String named = (String)attributes.get("Named");
        if (named != null) {
            attributes.put("Named", SimpleNamedDestination.unEscapeBinaryString(named));
        }
        if ((named = (String)attributes.get("NamedN")) != null) {
            attributes.put("NamedN", SimpleNamedDestination.unEscapeBinaryString(named));
        }
        if (this.attr.isEmpty()) {
            this.topList.add(attributes);
        } else {
            HashMap<String, Object> parent = this.attr.peek();
            ArrayList<HashMap<String, Object>> kids = (ArrayList<HashMap<String, Object>>)parent.get("Kids");
            if (kids == null) {
                kids = new ArrayList<HashMap<String, Object>>();
                parent.put("Kids", kids);
            }
            kids.add(attributes);
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String tag, Map<String, String> h) {
        if (this.topList == null) {
            if (tag.equals("Bookmark")) {
                this.topList = new ArrayList();
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("root.element.is.not.bookmark.1", tag));
        }
        if (!tag.equals("Title")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("tag.1.not.allowed", tag));
        }
        HashMap<String, String> attributes = new HashMap<String, String>(h);
        attributes.put("Title", "");
        attributes.remove("Kids");
        this.attr.push(attributes);
    }

    @Override
    public void text(String str) {
        if (this.attr.isEmpty()) {
            return;
        }
        HashMap<String, Object> attributes = this.attr.peek();
        String title = (String)attributes.get("Title");
        title = title + str;
        attributes.put("Title", title);
    }
}

