/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumberTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStructureElement;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.interfaces.IPdfStructureElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfStructureTreeRoot
extends PdfDictionary
implements IPdfStructureElement {
    private HashMap<Integer, PdfObject> parentTree = new HashMap();
    private PdfIndirectReference reference;
    private PdfDictionary classMap = null;
    protected HashMap<PdfName, PdfObject> classes = null;
    private HashMap<Integer, PdfIndirectReference> numTree = null;
    private PdfWriter writer;

    PdfStructureTreeRoot(PdfWriter writer) {
        super(PdfName.STRUCTTREEROOT);
        this.writer = writer;
        this.reference = writer.getPdfIndirectReference();
    }

    private void createNumTree() throws IOException {
        if (this.numTree != null) {
            return;
        }
        this.numTree = new HashMap();
        for (Integer i : this.parentTree.keySet()) {
            PdfObject obj = this.parentTree.get(i);
            if (obj.isArray()) {
                PdfArray ar = (PdfArray)obj;
                this.numTree.put(i, this.writer.addToBody(ar).getIndirectReference());
                continue;
            }
            if (!(obj instanceof PdfIndirectReference)) continue;
            this.numTree.put(i, (PdfIndirectReference)obj);
        }
    }

    public void mapRole(PdfName used, PdfName standard) {
        PdfDictionary rm2 = (PdfDictionary)this.get(PdfName.ROLEMAP);
        if (rm2 == null) {
            rm2 = new PdfDictionary();
            this.put(PdfName.ROLEMAP, rm2);
        }
        rm2.put(used, standard);
    }

    public void mapClass(PdfName name, PdfObject object) {
        if (this.classMap == null) {
            this.classMap = new PdfDictionary();
            this.classes = new HashMap();
        }
        this.classes.put(name, object);
    }

    public PdfObject getMappedClass(PdfName name) {
        if (this.classes == null) {
            return null;
        }
        return this.classes.get(name);
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public HashMap<Integer, PdfIndirectReference> getNumTree() throws IOException {
        if (this.numTree == null) {
            this.createNumTree();
        }
        return this.numTree;
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    void setPageMark(int page, PdfIndirectReference struc) {
        Integer i = page;
        PdfArray ar = (PdfArray)this.parentTree.get(i);
        if (ar == null) {
            ar = new PdfArray();
            this.parentTree.put(i, ar);
        }
        ar.add(struc);
    }

    void setAnnotationMark(int structParentIndex, PdfIndirectReference struc) {
        this.parentTree.put(structParentIndex, struc);
    }

    private void nodeProcess(PdfDictionary struc, PdfIndirectReference reference) throws IOException {
        PdfObject obj = struc.get(PdfName.K);
        if (obj != null && obj.isArray()) {
            PdfArray ar = (PdfArray)obj;
            for (int k = 0; k < ar.size(); ++k) {
                PdfDictionary dictionary = ar.getAsDict(k);
                if (dictionary == null || !PdfName.STRUCTELEM.equals(dictionary.get(PdfName.TYPE)) || !(ar.getPdfObject(k) instanceof PdfStructureElement)) continue;
                PdfStructureElement e = (PdfStructureElement)dictionary;
                ar.set(k, e.getReference());
                this.nodeProcess(e, e.getReference());
            }
        }
        if (reference != null) {
            this.writer.addToBody((PdfObject)struc, reference);
        }
    }

    void buildTree() throws IOException {
        this.createNumTree();
        PdfDictionary dicTree = PdfNumberTree.writeTree(this.numTree, this.writer);
        if (dicTree != null) {
            this.put(PdfName.PARENTTREE, this.writer.addToBody(dicTree).getIndirectReference());
        }
        if (this.classMap != null && !this.classes.isEmpty()) {
            for (Map.Entry<PdfName, PdfObject> entry2 : this.classes.entrySet()) {
                PdfObject value2 = entry2.getValue();
                if (value2.isDictionary()) {
                    this.classMap.put(entry2.getKey(), this.writer.addToBody(value2).getIndirectReference());
                    continue;
                }
                if (!value2.isArray()) continue;
                PdfArray newArray = new PdfArray();
                PdfArray array = (PdfArray)value2;
                for (int i = 0; i < array.size(); ++i) {
                    if (!array.getPdfObject(i).isDictionary()) continue;
                    newArray.add(this.writer.addToBody(array.getAsDict(i)).getIndirectReference());
                }
                this.classMap.put(entry2.getKey(), newArray);
            }
            this.put(PdfName.CLASSMAP, this.writer.addToBody(this.classMap).getIndirectReference());
        }
        this.nodeProcess(this, this.reference);
    }

    @Override
    public PdfObject getAttribute(PdfName name) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr != null && attr.contains(name)) {
            return attr.get(name);
        }
        return null;
    }

    @Override
    public void setAttribute(PdfName name, PdfObject obj) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr == null) {
            attr = new PdfDictionary();
            this.put(PdfName.A, attr);
        }
        attr.put(name, obj);
    }
}

