/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PdfObject;

public class PdfNumber
extends PdfObject {
    private double value;

    public PdfNumber(String content) {
        super(2);
        try {
            this.value = Double.parseDouble(content.trim());
            this.setContent(content);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("1.is.not.a.valid.number.2", content, nfe.toString()));
        }
    }

    public PdfNumber(int value2) {
        super(2);
        this.value = value2;
        this.setContent(String.valueOf(value2));
    }

    public PdfNumber(long value2) {
        super(2);
        this.value = value2;
        this.setContent(String.valueOf(value2));
    }

    public PdfNumber(double value2) {
        super(2);
        this.value = value2;
        this.setContent(ByteBuffer.formatDouble(value2));
    }

    public PdfNumber(float value2) {
        this((double)value2);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public void increment() {
        this.value += 1.0;
        this.setContent(ByteBuffer.formatDouble(this.value));
    }
}

