/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReaderInstance;
import com.itextpdf.text.pdf.PdfSpotColor;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfTransparencyGroup;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;

public class PdfImportedPage
extends PdfTemplate {
    PdfReaderInstance readerInstance;
    int pageNumber;
    int rotation;
    protected boolean toCopy = true;

    PdfImportedPage(PdfReaderInstance readerInstance, PdfWriter writer, int pageNumber) {
        this.readerInstance = readerInstance;
        this.pageNumber = pageNumber;
        this.writer = writer;
        this.rotation = readerInstance.getReader().getPageRotation(pageNumber);
        this.bBox = readerInstance.getReader().getPageSize(pageNumber);
        this.setMatrix(1.0f, 0.0f, 0.0f, 1.0f, -this.bBox.getLeft(), -this.bBox.getBottom());
        this.type = 2;
    }

    public PdfImportedPage getFromReader() {
        return this;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void addImage(Image image, float a, float b, float c, float d, float e, float f) throws DocumentException {
        this.throwError();
    }

    public void addTemplate(PdfTemplate template, float a, float b, float c, float d, float e, float f) {
        this.throwError();
    }

    public PdfContentByte getDuplicate() {
        this.throwError();
        return null;
    }

    public PdfStream getFormXObject(int compressionLevel) throws IOException {
        return this.readerInstance.getFormXObject(this.pageNumber, compressionLevel);
    }

    public void setColorFill(PdfSpotColor sp2, float tint) {
        this.throwError();
    }

    public void setColorStroke(PdfSpotColor sp2, float tint) {
        this.throwError();
    }

    PdfObject getResources() {
        return this.readerInstance.getResources(this.pageNumber);
    }

    public void setFontAndSize(BaseFont bf, float size2) {
        this.throwError();
    }

    public void setGroup(PdfTransparencyGroup group) {
        this.throwError();
    }

    void throwError() {
        throw new RuntimeException(MessageLocalization.getComposedMessage("content.can.not.be.added.to.a.pdfimportedpage", new Object[0]));
    }

    PdfReaderInstance getPdfReaderInstance() {
        return this.readerInstance;
    }

    public boolean isToCopy() {
        return this.toCopy;
    }

    public void setCopied() {
        this.toCopy = false;
    }
}

