/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfString;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class PdfDate
extends PdfString {
    private static final int[] DATE_SPACE = new int[]{1, 4, 0, 2, 2, -1, 5, 2, 0, 11, 2, 0, 12, 2, 0, 13, 2, 0};

    public PdfDate(Calendar d) {
        StringBuffer date = new StringBuffer("D:");
        date.append(this.setLength(d.get(1), 4));
        date.append(this.setLength(d.get(2) + 1, 2));
        date.append(this.setLength(d.get(5), 2));
        date.append(this.setLength(d.get(11), 2));
        date.append(this.setLength(d.get(12), 2));
        date.append(this.setLength(d.get(13), 2));
        int timezone = (d.get(15) + d.get(16)) / 3600000;
        if (timezone == 0) {
            date.append('Z');
        } else if (timezone < 0) {
            date.append('-');
            timezone = -timezone;
        } else {
            date.append('+');
        }
        if (timezone != 0) {
            date.append(this.setLength(timezone, 2)).append('\'');
            int zone = Math.abs((d.get(15) + d.get(16)) / 60000) - timezone * 60;
            date.append(this.setLength(zone, 2)).append('\'');
        }
        this.value = date.toString();
    }

    public PdfDate() {
        this(new GregorianCalendar());
    }

    private String setLength(int i, int length) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(i);
        while (tmp.length() < length) {
            tmp.insert(0, "0");
        }
        tmp.setLength(length);
        return tmp.toString();
    }

    public String getW3CDate() {
        return PdfDate.getW3CDate(this.value);
    }

    public static String getW3CDate(String d) {
        if (d.startsWith("D:")) {
            d = d.substring(2);
        }
        StringBuffer sb = new StringBuffer();
        if (d.length() < 4) {
            return "0000";
        }
        sb.append(d.substring(0, 4));
        d = d.substring(4);
        if (d.length() < 2) {
            return sb.toString();
        }
        sb.append('-').append(d.substring(0, 2));
        d = d.substring(2);
        if (d.length() < 2) {
            return sb.toString();
        }
        sb.append('-').append(d.substring(0, 2));
        d = d.substring(2);
        if (d.length() < 2) {
            return sb.toString();
        }
        sb.append('T').append(d.substring(0, 2));
        d = d.substring(2);
        if (d.length() < 2) {
            sb.append(":00Z");
            return sb.toString();
        }
        sb.append(':').append(d.substring(0, 2));
        d = d.substring(2);
        if (d.length() < 2) {
            sb.append('Z');
            return sb.toString();
        }
        sb.append(':').append(d.substring(0, 2));
        d = d.substring(2);
        if (d.startsWith("-") || d.startsWith("+")) {
            String sign2 = d.substring(0, 1);
            d = d.substring(1);
            String h = "00";
            String m = "00";
            if (d.length() >= 2) {
                h = d.substring(0, 2);
                if (d.length() > 2 && (d = d.substring(3)).length() >= 2) {
                    m = d.substring(0, 2);
                }
                sb.append(sign2).append(h).append(':').append(m);
                return sb.toString();
            }
        }
        sb.append('Z');
        return sb.toString();
    }

    public static Calendar decode(String s2) {
        try {
            GregorianCalendar calendar;
            if (s2.startsWith("D:")) {
                s2 = s2.substring(2);
            }
            int slen = s2.length();
            int idx = s2.indexOf(90);
            if (idx >= 0) {
                slen = idx;
                calendar = new GregorianCalendar(new SimpleTimeZone(0, "ZPDF"));
            } else {
                int sign2 = 1;
                idx = s2.indexOf(43);
                if (idx < 0 && (idx = s2.indexOf(45)) >= 0) {
                    sign2 = -1;
                }
                if (idx < 0) {
                    calendar = new GregorianCalendar();
                } else {
                    int offset = Integer.parseInt(s2.substring(idx + 1, idx + 3)) * 60;
                    if (idx + 5 < s2.length()) {
                        offset += Integer.parseInt(s2.substring(idx + 4, idx + 6));
                    }
                    calendar = new GregorianCalendar(new SimpleTimeZone(offset * sign2 * 60000, "ZPDF"));
                    slen = idx;
                }
            }
            calendar.clear();
            idx = 0;
            for (int k = 0; k < DATE_SPACE.length && idx < slen; idx += DATE_SPACE[k + 1], k += 3) {
                calendar.set(DATE_SPACE[k], Integer.parseInt(s2.substring(idx, idx + DATE_SPACE[k + 1])) + DATE_SPACE[k + 2]);
            }
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }
}

