/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PdfObject;

public class PdfBoolean
extends PdfObject {
    public static final PdfBoolean PDFTRUE = new PdfBoolean(true);
    public static final PdfBoolean PDFFALSE = new PdfBoolean(false);
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private boolean value;

    public PdfBoolean(boolean value2) {
        super(1);
        if (value2) {
            this.setContent(TRUE);
        } else {
            this.setContent(FALSE);
        }
        this.value = value2;
    }

    public PdfBoolean(String value2) throws BadPdfFormatException {
        super(1, value2);
        if (value2.equals(TRUE)) {
            this.value = true;
        } else if (value2.equals(FALSE)) {
            this.value = false;
        } else {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("the.value.has.to.be.true.of.false.instead.of.1", value2));
        }
    }

    public boolean booleanValue() {
        return this.value;
    }

    public String toString() {
        return this.value ? TRUE : FALSE;
    }
}

