/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashtable
implements Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public LongHashtable() {
        this(150, 0.75f);
    }

    public LongHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.capacity.1", initialCapacity));
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.load.1", String.valueOf(loadFactor)));
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(long value2) {
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == value2) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(long value2) {
        return this.contains(value2);
    }

    public boolean containsKey(long key) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index2 = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public long get(long key) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index2 = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return 0L;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index2];
                newMap[index2] = e;
            }
        }
    }

    public long put(long key, long value2) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index2 = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                long old = e.value;
                e.value = value2;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index2 = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index2] = e = new Entry(hash, key, value2, tab[index2]);
        ++this.count;
        return 0L;
    }

    public long remove(long key) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index2 = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index2] = e.next;
                }
                --this.count;
                long oldValue = e.value;
                e.value = 0L;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return 0L;
    }

    public void clear() {
        Entry[] tab = this.table;
        int index2 = tab.length;
        while (--index2 >= 0) {
            tab[index2] = null;
        }
        this.count = 0;
    }

    public Iterator<Entry> getEntryIterator() {
        return new LongHashtableIterator(this.table);
    }

    public long[] toOrderedKeys() {
        long[] res = this.getKeys();
        Arrays.sort(res);
        return res;
    }

    public long[] getKeys() {
        long[] res = new long[this.count];
        int ptr = 0;
        int index2 = this.table.length;
        Entry entry2 = null;
        while (true) {
            if (entry2 == null) {
                while (index2-- > 0 && (entry2 = this.table[index2]) == null) {
                }
            }
            if (entry2 == null) break;
            Entry e = entry2;
            entry2 = e.next;
            res[ptr++] = e.key;
        }
        return res;
    }

    public long getOneKey() {
        if (this.count == 0) {
            return 0L;
        }
        int index2 = this.table.length;
        Entry entry2 = null;
        while (index2-- > 0 && (entry2 = this.table[index2]) == null) {
        }
        if (entry2 == null) {
            return 0L;
        }
        return entry2.key;
    }

    public Object clone() {
        try {
            LongHashtable t = (LongHashtable)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongHashtableIterator
    implements Iterator<Entry> {
        int index;
        Entry[] table;
        Entry entry;

        LongHashtableIterator(Entry[] table) {
            this.table = table;
            this.index = table.length;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Entry next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e = this.entry;
                this.entry = e.next;
                return e;
            }
            throw new NoSuchElementException(MessageLocalization.getComposedMessage("inthashtableiterator", new Object[0]));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("remove.not.supported", new Object[0]));
        }
    }

    static class Entry {
        int hash;
        long key;
        long value;
        Entry next;

        protected Entry(int hash, long key, long value2, Entry next2) {
            this.hash = hash;
            this.key = key;
            this.value = value2;
            this.next = next2;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        protected Object clone() {
            Entry entry2 = new Entry(this.hash, this.key, this.value, this.next != null ? (Entry)this.next.clone() : null);
            return entry2;
        }
    }
}

