/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.io;

import com.itextpdf.text.io.RandomAccessSource;
import java.io.IOException;

class GroupedRandomAccessSource
implements RandomAccessSource {
    private final SourceEntry[] sources;
    private SourceEntry currentSourceEntry;
    private final long size;

    public GroupedRandomAccessSource(RandomAccessSource[] sources) throws IOException {
        this.sources = new SourceEntry[sources.length];
        long totalSize = 0L;
        for (int i = 0; i < sources.length; ++i) {
            this.sources[i] = new SourceEntry(i, sources[i], totalSize);
            totalSize += sources[i].length();
        }
        this.size = totalSize;
        this.currentSourceEntry = this.sources[sources.length - 1];
        this.sourceInUse(this.currentSourceEntry.source);
    }

    protected int getStartingSourceIndex(long offset) {
        if (offset >= this.currentSourceEntry.firstByte) {
            return this.currentSourceEntry.index;
        }
        return 0;
    }

    private SourceEntry getSourceEntryForOffset(long offset) throws IOException {
        int startAt;
        if (offset >= this.size) {
            return null;
        }
        if (offset >= this.currentSourceEntry.firstByte && offset <= this.currentSourceEntry.lastByte) {
            return this.currentSourceEntry;
        }
        this.sourceReleased(this.currentSourceEntry.source);
        for (int i = startAt = this.getStartingSourceIndex(offset); i < this.sources.length; ++i) {
            if (offset < this.sources[i].firstByte || offset > this.sources[i].lastByte) continue;
            this.currentSourceEntry = this.sources[i];
            this.sourceInUse(this.currentSourceEntry.source);
            return this.currentSourceEntry;
        }
        return null;
    }

    protected void sourceReleased(RandomAccessSource source) throws IOException {
    }

    protected void sourceInUse(RandomAccessSource source) throws IOException {
    }

    public int get(long position) throws IOException {
        SourceEntry entry2 = this.getSourceEntryForOffset(position);
        if (entry2 == null) {
            return -1;
        }
        return entry2.source.get(entry2.offsetN(position));
    }

    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        int remaining;
        int count2;
        SourceEntry entry2 = this.getSourceEntryForOffset(position);
        if (entry2 == null) {
            return -1;
        }
        long offN = entry2.offsetN(position);
        for (remaining = len; remaining > 0 && entry2 != null && offN <= entry2.source.length() && (count2 = entry2.source.get(offN, bytes, off, remaining)) != -1; remaining -= count2) {
            off += count2;
            offN = 0L;
            entry2 = this.getSourceEntryForOffset(position += (long)count2);
        }
        return remaining == len ? -1 : len - remaining;
    }

    public long length() {
        return this.size;
    }

    public void close() throws IOException {
        for (SourceEntry entry2 : this.sources) {
            entry2.source.close();
        }
    }

    private static class SourceEntry {
        final RandomAccessSource source;
        final long firstByte;
        final long lastByte;
        final int index;

        public SourceEntry(int index2, RandomAccessSource source, long offset) {
            this.index = index2;
            this.source = source;
            this.firstByte = offset;
            this.lastByte = offset + source.length() - 1L;
        }

        public long offsetN(long absoluteOffset) {
            return absoluteOffset - this.firstByte;
        }
    }
}

