/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheet {
    protected Map<String, Map<String, String>> tagMap = new HashMap<String, Map<String, String>>();
    protected Map<String, Map<String, String>> classMap = new HashMap<String, Map<String, String>>();

    public void loadTagStyle(String tag, Map<String, String> attrs) {
        this.tagMap.put(tag.toLowerCase(), attrs);
    }

    public void loadTagStyle(String tag, String key, String value2) {
        Map<String, String> styles = this.tagMap.get(tag = tag.toLowerCase());
        if (styles == null) {
            styles = new HashMap<String, String>();
            this.tagMap.put(tag, styles);
        }
        styles.put(key, value2);
    }

    public void loadStyle(String className, HashMap<String, String> attrs) {
        this.classMap.put(className.toLowerCase(), attrs);
    }

    public void loadStyle(String className, String key, String value2) {
        Map<String, String> styles = this.classMap.get(className = className.toLowerCase());
        if (styles == null) {
            styles = new HashMap<String, String>();
            this.classMap.put(className, styles);
        }
        styles.put(key, value2);
    }

    public void applyStyle(String tag, Map<String, String> attrs) {
        String cm;
        Map<String, String> map2 = this.tagMap.get(tag.toLowerCase());
        if (map2 != null) {
            HashMap<String, String> temp = new HashMap<String, String>(map2);
            temp.putAll(attrs);
            attrs.putAll(temp);
        }
        if ((cm = attrs.get("class")) == null) {
            return;
        }
        map2 = this.classMap.get(cm.toLowerCase());
        if (map2 == null) {
            return;
        }
        attrs.remove("class");
        HashMap<String, String> temp = new HashMap<String, String>(map2);
        temp.putAll(attrs);
        attrs.putAll(temp);
    }

    public static void resolveStyleAttribute(Map<String, String> h, ChainedProperties chain2) {
        String style = h.get("style");
        if (style == null) {
            return;
        }
        Properties prop = HtmlUtilities.parseAttributes(style);
        for (Object element : prop.keySet()) {
            String key = (String)element;
            if (key.equals("font-family")) {
                h.put("face", prop.getProperty(key));
                continue;
            }
            if (key.equals("font-size")) {
                float actualFontSize = HtmlUtilities.parseLength(chain2.getProperty("size"), 12.0f);
                if (actualFontSize <= 0.0f) {
                    actualFontSize = 12.0f;
                }
                h.put("size", Float.toString(HtmlUtilities.parseLength(prop.getProperty(key), actualFontSize)) + "pt");
                continue;
            }
            if (key.equals("font-style")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h.put("i", null);
                continue;
            }
            if (key.equals("font-weight")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h.put("b", null);
                continue;
            }
            if (key.equals("text-decoration")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h.put("u", null);
                continue;
            }
            if (key.equals("color")) {
                BaseColor c = HtmlUtilities.decodeColor(prop.getProperty(key));
                if (c == null) continue;
                int hh = c.getRGB();
                String hs = Integer.toHexString(hh);
                hs = "000000" + hs;
                hs = "#" + hs.substring(hs.length() - 6);
                h.put("color", hs);
                continue;
            }
            if (key.equals("line-height")) {
                String ss = prop.getProperty(key).trim();
                float actualFontSize = HtmlUtilities.parseLength(chain2.getProperty("size"), 12.0f);
                if (actualFontSize <= 0.0f) {
                    actualFontSize = 12.0f;
                }
                float v = HtmlUtilities.parseLength(prop.getProperty(key), actualFontSize);
                if (ss.endsWith("%")) {
                    h.put("leading", "0," + v / 100.0f);
                    return;
                }
                if ("normal".equalsIgnoreCase(ss)) {
                    h.put("leading", "0,1.5");
                    return;
                }
                h.put("leading", v + ",0");
                continue;
            }
            if (key.equals("text-align")) {
                String ss = prop.getProperty(key).trim().toLowerCase();
                h.put("align", ss);
                continue;
            }
            if (!key.equals("padding-left")) continue;
            String ss = prop.getProperty(key).trim().toLowerCase();
            h.put("indent", Float.toString(HtmlUtilities.parseLength(ss)));
        }
    }
}

