/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocListener;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import com.itextpdf.text.html.simpleparser.ImageProvider;
import com.itextpdf.text.pdf.HyphenationAuto;
import com.itextpdf.text.pdf.HyphenationEvent;
import com.itextpdf.text.pdf.draw.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactory {
    private FontProvider provider = FontFactory.getFontImp();

    public void setFontProvider(FontProvider provider) {
        this.provider = provider;
    }

    public FontProvider getFontProvider() {
        return this.provider;
    }

    public Font getFont(ChainedProperties chain2) {
        String encoding;
        String face = chain2.getProperty("face");
        if (face == null || face.trim().length() == 0) {
            face = chain2.getProperty("font-family");
        }
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (!this.provider.isRegistered(face)) continue;
            }
        }
        if ((encoding = chain2.getProperty("encoding")) == null) {
            encoding = "Cp1252";
        }
        String value2 = chain2.getProperty("size");
        float size2 = 12.0f;
        if (value2 != null) {
            size2 = Float.parseFloat(value2);
        }
        int style = 0;
        String decoration = chain2.getProperty("text-decoration");
        if (decoration != null && decoration.trim().length() != 0) {
            if ("underline".equals(decoration)) {
                style |= 4;
            } else if ("line-through".equals(decoration)) {
                style |= 8;
            }
        }
        if (chain2.hasProperty("i")) {
            style |= 2;
        }
        if (chain2.hasProperty("b")) {
            style |= 1;
        }
        if (chain2.hasProperty("u")) {
            style |= 4;
        }
        if (chain2.hasProperty("s")) {
            style |= 8;
        }
        BaseColor color = HtmlUtilities.decodeColor(chain2.getProperty("color"));
        return this.provider.getFont(face, encoding, true, size2, style, color);
    }

    public Chunk createChunk(String content, ChainedProperties chain2) {
        Font font = this.getFont(chain2);
        Chunk ck = new Chunk(content, font);
        if (chain2.hasProperty("sub")) {
            ck.setTextRise(-font.getSize() / 2.0f);
        } else if (chain2.hasProperty("sup")) {
            ck.setTextRise(font.getSize() / 2.0f);
        }
        ck.setHyphenation(this.getHyphenation(chain2));
        return ck;
    }

    public Paragraph createParagraph(ChainedProperties chain2) {
        Paragraph paragraph = new Paragraph();
        this.updateElement(paragraph, chain2);
        return paragraph;
    }

    public ListItem createListItem(ChainedProperties chain2) {
        ListItem item = new ListItem();
        this.updateElement(item, chain2);
        return item;
    }

    protected void updateElement(Paragraph paragraph, ChainedProperties chain2) {
        String value2 = chain2.getProperty("align");
        paragraph.setAlignment(HtmlUtilities.alignmentValue(value2));
        paragraph.setHyphenation(this.getHyphenation(chain2));
        ElementFactory.setParagraphLeading(paragraph, chain2.getProperty("leading"));
        value2 = chain2.getProperty("after");
        if (value2 != null) {
            try {
                paragraph.setSpacingBefore(Float.parseFloat(value2));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value2 = chain2.getProperty("after")) != null) {
            try {
                paragraph.setSpacingAfter(Float.parseFloat(value2));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value2 = chain2.getProperty("extraparaspace")) != null) {
            try {
                paragraph.setExtraParagraphSpace(Float.parseFloat(value2));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value2 = chain2.getProperty("indent")) != null) {
            try {
                paragraph.setIndentationLeft(Float.parseFloat(value2));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected static void setParagraphLeading(Paragraph paragraph, String leading) {
        if (leading == null) {
            paragraph.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.parseFloat(v);
            if (!tk.hasMoreTokens()) {
                paragraph.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.parseFloat(v);
            paragraph.setLeading(v1, v2);
        }
        catch (Exception e) {
            paragraph.setLeading(0.0f, 1.5f);
        }
    }

    public HyphenationEvent getHyphenation(ChainedProperties chain2) {
        int leftMin;
        String value2 = chain2.getProperty("hyphenation");
        if (value2 == null || value2.length() == 0) {
            return null;
        }
        int pos = value2.indexOf(95);
        if (pos == -1) {
            return new HyphenationAuto(value2, null, 2, 2);
        }
        String lang = value2.substring(0, pos);
        String country = value2.substring(pos + 1);
        if ((pos = country.indexOf(44)) == -1) {
            return new HyphenationAuto(lang, country, 2, 2);
        }
        int rightMin = 2;
        value2 = country.substring(pos + 1);
        country = country.substring(0, pos);
        pos = value2.indexOf(44);
        if (pos == -1) {
            leftMin = Integer.parseInt(value2);
        } else {
            leftMin = Integer.parseInt(value2.substring(0, pos));
            rightMin = Integer.parseInt(value2.substring(pos + 1));
        }
        return new HyphenationAuto(lang, country, leftMin, rightMin);
    }

    public LineSeparator createLineSeparator(Map<String, String> attrs, float offset) {
        float tmpSize;
        float lineWidth = 1.0f;
        String size2 = attrs.get("size");
        if (size2 != null && (tmpSize = HtmlUtilities.parseLength(size2, 12.0f)) > 0.0f) {
            lineWidth = tmpSize;
        }
        String width = attrs.get("width");
        float percentage = 100.0f;
        if (width != null) {
            float tmpWidth = HtmlUtilities.parseLength(width, 12.0f);
            if (tmpWidth > 0.0f) {
                percentage = tmpWidth;
            }
            if (!width.endsWith("%")) {
                percentage = 100.0f;
            }
        }
        BaseColor lineColor = null;
        int align = HtmlUtilities.alignmentValue(attrs.get("align"));
        return new LineSeparator(lineWidth, percentage, lineColor, align, offset);
    }

    public Image createImage(String src, Map<String, String> attrs, ChainedProperties chain2, DocListener document2, ImageProvider img_provider, HashMap<String, Image> img_store, String img_baseurl) throws DocumentException, IOException {
        String after;
        Image tim;
        Image img = null;
        if (img_provider != null) {
            img = img_provider.getImage(src, attrs, chain2, document2);
        }
        if (img == null && img_store != null && (tim = img_store.get(src)) != null) {
            img = Image.getInstance(tim);
        }
        if (img != null) {
            return img;
        }
        if (!src.startsWith("http") && img_baseurl != null) {
            src = img_baseurl + src;
        } else if (img == null && !src.startsWith("http")) {
            String path = chain2.getProperty("image_path");
            if (path == null) {
                path = "";
            }
            src = new File(path, src).getPath();
        }
        img = Image.getInstance(src);
        if (img == null) {
            return null;
        }
        float actualFontSize = HtmlUtilities.parseLength(chain2.getProperty("size"), 12.0f);
        if (actualFontSize <= 0.0f) {
            actualFontSize = 12.0f;
        }
        String width = attrs.get("width");
        float widthInPoints = HtmlUtilities.parseLength(width, actualFontSize);
        String height = attrs.get("height");
        float heightInPoints = HtmlUtilities.parseLength(height, actualFontSize);
        if (widthInPoints > 0.0f && heightInPoints > 0.0f) {
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0.0f) {
            heightInPoints = img.getHeight() * widthInPoints / img.getWidth();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0.0f) {
            widthInPoints = img.getWidth() * heightInPoints / img.getHeight();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        }
        String before = chain2.getProperty("before");
        if (before != null) {
            img.setSpacingBefore(Float.parseFloat(before));
        }
        if ((after = chain2.getProperty("after")) != null) {
            img.setSpacingAfter(Float.parseFloat(after));
        }
        img.setWidthPercentage(0.0f);
        return img;
    }

    public List createList(String tag, ChainedProperties chain2) {
        List list2;
        if ("ul".equalsIgnoreCase(tag)) {
            list2 = new List(false);
            list2.setListSymbol("\u2022 ");
        } else {
            list2 = new List(true);
        }
        try {
            list2.setIndentationLeft(new Float(chain2.getProperty("indent")).floatValue());
        }
        catch (Exception e) {
            list2.setAutoindent(true);
        }
        return list2;
    }
}

