/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import com.itextpdf.text.pdf.PdfPCell;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellWrapper
implements TextElementArray {
    private final PdfPCell cell;
    private float width;
    private boolean percentage;

    public CellWrapper(String tag, ChainedProperties chain2) {
        this.cell = this.createPdfPCell(tag, chain2);
        String value2 = chain2.getProperty("width");
        if (value2 != null) {
            if ((value2 = value2.trim()).endsWith("%")) {
                this.percentage = true;
                value2 = value2.substring(0, value2.length() - 1);
            }
            this.width = Float.parseFloat(value2);
        }
    }

    public PdfPCell createPdfPCell(String tag, ChainedProperties chain2) {
        PdfPCell cell = new PdfPCell((Phrase)null);
        String value2 = chain2.getProperty("colspan");
        if (value2 != null) {
            cell.setColspan(Integer.parseInt(value2));
        }
        if ((value2 = chain2.getProperty("rowspan")) != null) {
            cell.setRowspan(Integer.parseInt(value2));
        }
        if (tag.equals("th")) {
            cell.setHorizontalAlignment(1);
        }
        if ((value2 = chain2.getProperty("align")) != null) {
            cell.setHorizontalAlignment(HtmlUtilities.alignmentValue(value2));
        }
        value2 = chain2.getProperty("valign");
        cell.setVerticalAlignment(5);
        if (value2 != null) {
            cell.setVerticalAlignment(HtmlUtilities.alignmentValue(value2));
        }
        value2 = chain2.getProperty("border");
        float border = 0.0f;
        if (value2 != null) {
            border = Float.parseFloat(value2);
        }
        cell.setBorderWidth(border);
        value2 = chain2.getProperty("cellpadding");
        if (value2 != null) {
            cell.setPadding(Float.parseFloat(value2));
        }
        cell.setUseDescender(true);
        value2 = chain2.getProperty("bgcolor");
        cell.setBackgroundColor(HtmlUtilities.decodeColor(value2));
        return cell;
    }

    public PdfPCell getCell() {
        return this.cell;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    @Override
    public boolean add(Element o) {
        this.cell.addElement(o);
        return true;
    }

    @Override
    public List<Chunk> getChunks() {
        return null;
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    @Override
    public boolean process(ElementListener listener) {
        return false;
    }

    @Override
    public int type() {
        return 0;
    }
}

