/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactoryImp;
import com.itextpdf.text.error_messages.MessageLocalization;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontFactory {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES = "Times";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    private static FontFactoryImp fontImp = new FontFactoryImp();
    public static String defaultEncoding = "Cp1252";
    public static boolean defaultEmbedding = false;

    private FontFactory() {
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size2, int style, BaseColor color) {
        return fontImp.getFont(fontname, encoding, embedded, size2, style, color);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size2, int style, BaseColor color, boolean cached) {
        return fontImp.getFont(fontname, encoding, embedded, size2, style, color, cached);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size2, int style) {
        return FontFactory.getFont(fontname, encoding, embedded, size2, style, null);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size2) {
        return FontFactory.getFont(fontname, encoding, embedded, size2, -1, null);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded) {
        return FontFactory.getFont(fontname, encoding, embedded, -1.0f, -1, null);
    }

    public static Font getFont(String fontname, String encoding, float size2, int style, BaseColor color) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, size2, style, color);
    }

    public static Font getFont(String fontname, String encoding, float size2, int style) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, size2, style, null);
    }

    public static Font getFont(String fontname, String encoding, float size2) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, size2, -1, null);
    }

    public static Font getFont(String fontname, String encoding) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, -1.0f, -1, null);
    }

    public static Font getFont(String fontname, float size2, int style, BaseColor color) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size2, style, color);
    }

    public static Font getFont(String fontname, float size2, BaseColor color) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size2, -1, color);
    }

    public static Font getFont(String fontname, float size2, int style) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size2, style, null);
    }

    public static Font getFont(String fontname, float size2) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size2, -1, null);
    }

    public static Font getFont(String fontname) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, -1.0f, -1, null);
    }

    public static void registerFamily(String familyName, String fullName, String path) {
        fontImp.registerFamily(familyName, fullName, path);
    }

    public static void register(String path) {
        FontFactory.register(path, null);
    }

    public static void register(String path, String alias) {
        fontImp.register(path, alias);
    }

    public static int registerDirectory(String dir) {
        return fontImp.registerDirectory(dir);
    }

    public static int registerDirectory(String dir, boolean scanSubdirectories) {
        return fontImp.registerDirectory(dir, scanSubdirectories);
    }

    public static int registerDirectories() {
        return fontImp.registerDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return fontImp.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFamilies() {
        return fontImp.getRegisteredFamilies();
    }

    public static boolean contains(String fontname) {
        return fontImp.isRegistered(fontname);
    }

    public static boolean isRegistered(String fontname) {
        return fontImp.isRegistered(fontname);
    }

    public static FontFactoryImp getFontImp() {
        return fontImp;
    }

    public static void setFontImp(FontFactoryImp fontImp) {
        if (fontImp == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("fontfactoryimp.cannot.be.null", new Object[0]));
        }
        FontFactory.fontImp = fontImp;
    }
}

