/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ExternalTypeHandler {
    private final ExtTypedProperty[] _properties;
    private final HashMap<String, Integer> _nameToPropertyIndex;
    private final String[] _typeIds;
    private final TokenBuffer[] _tokens;

    protected ExternalTypeHandler(ExtTypedProperty[] properties, HashMap<String, Integer> nameToPropertyIndex, String[] typeIds, TokenBuffer[] tokens) {
        this._properties = properties;
        this._nameToPropertyIndex = nameToPropertyIndex;
        this._typeIds = typeIds;
        this._tokens = tokens;
    }

    protected ExternalTypeHandler(ExternalTypeHandler h) {
        this._properties = h._properties;
        this._nameToPropertyIndex = h._nameToPropertyIndex;
        int len = this._properties.length;
        this._typeIds = new String[len];
        this._tokens = new TokenBuffer[len];
    }

    public ExternalTypeHandler start() {
        return new ExternalTypeHandler(this);
    }

    public boolean handleTypePropertyValue(JsonParser jp, DeserializationContext ctxt, String propName, Object bean) throws IOException {
        boolean canDeserialize;
        Integer I = this._nameToPropertyIndex.get(propName);
        if (I == null) {
            return false;
        }
        int index2 = I;
        ExtTypedProperty prop = this._properties[index2];
        if (!prop.hasTypePropertyName(propName)) {
            return false;
        }
        String typeId = jp.getText();
        boolean bl = canDeserialize = bean != null && this._tokens[index2] != null;
        if (canDeserialize) {
            this._deserializeAndSet(jp, ctxt, bean, index2, typeId);
            this._tokens[index2] = null;
        } else {
            this._typeIds[index2] = typeId;
        }
        return true;
    }

    public boolean handlePropertyValue(JsonParser jp, DeserializationContext ctxt, String propName, Object bean) throws IOException {
        boolean canDeserialize;
        Integer I = this._nameToPropertyIndex.get(propName);
        if (I == null) {
            return false;
        }
        int index2 = I;
        ExtTypedProperty prop = this._properties[index2];
        if (prop.hasTypePropertyName(propName)) {
            this._typeIds[index2] = jp.getText();
            jp.skipChildren();
            canDeserialize = bean != null && this._tokens[index2] != null;
        } else {
            TokenBuffer tokens = new TokenBuffer(jp);
            tokens.copyCurrentStructure(jp);
            this._tokens[index2] = tokens;
            boolean bl = canDeserialize = bean != null && this._typeIds[index2] != null;
        }
        if (canDeserialize) {
            String typeId = this._typeIds[index2];
            this._typeIds[index2] = null;
            this._deserializeAndSet(jp, ctxt, bean, index2, typeId);
            this._tokens[index2] = null;
        }
        return true;
    }

    public Object complete(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException {
        int len = this._properties.length;
        for (int i = 0; i < len; ++i) {
            String typeId = this._typeIds[i];
            if (typeId == null) {
                TokenBuffer tokens = this._tokens[i];
                if (tokens == null) continue;
                JsonToken t = tokens.firstToken();
                if (t != null && t.isScalarValue()) {
                    JsonParser buffered = tokens.asParser(jp);
                    buffered.nextToken();
                    SettableBeanProperty extProp = this._properties[i].getProperty();
                    Object result2 = TypeDeserializer.deserializeIfNatural(buffered, ctxt, extProp.getType());
                    if (result2 != null) {
                        extProp.set(bean, result2);
                        continue;
                    }
                    if (!this._properties[i].hasDefaultType()) {
                        throw ctxt.mappingException("Missing external type id property '" + this._properties[i].getTypePropertyName() + "'");
                    }
                    typeId = this._properties[i].getDefaultTypeId();
                }
            } else if (this._tokens[i] == null) {
                SettableBeanProperty prop = this._properties[i].getProperty();
                throw ctxt.mappingException("Missing property '" + prop.getName() + "' for external type id '" + this._properties[i].getTypePropertyName());
            }
            this._deserializeAndSet(jp, ctxt, bean, i, typeId);
        }
        return bean;
    }

    public Object complete(JsonParser jp, DeserializationContext ctxt, PropertyValueBuffer buffer, PropertyBasedCreator creator) throws IOException {
        int i;
        int len = this._properties.length;
        Object[] values = new Object[len];
        for (i = 0; i < len; ++i) {
            String typeId = this._typeIds[i];
            if (typeId == null) {
                if (this._tokens[i] == null) continue;
                if (!this._properties[i].hasDefaultType()) {
                    throw ctxt.mappingException("Missing external type id property '" + this._properties[i].getTypePropertyName() + "'");
                }
                typeId = this._properties[i].getDefaultTypeId();
            } else if (this._tokens[i] == null) {
                SettableBeanProperty prop = this._properties[i].getProperty();
                throw ctxt.mappingException("Missing property '" + prop.getName() + "' for external type id '" + this._properties[i].getTypePropertyName());
            }
            values[i] = this._deserialize(jp, ctxt, i, typeId);
        }
        for (i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._properties[i].getProperty();
            if (creator.findCreatorProperty(prop.getName()) == null) continue;
            buffer.assignParameter(prop.getCreatorIndex(), values[i]);
        }
        Object bean = creator.build(ctxt, buffer);
        for (int i2 = 0; i2 < len; ++i2) {
            SettableBeanProperty prop = this._properties[i2].getProperty();
            if (creator.findCreatorProperty(prop.getName()) != null) continue;
            prop.set(bean, values[i2]);
        }
        return bean;
    }

    protected final Object _deserialize(JsonParser jp, DeserializationContext ctxt, int index2, String typeId) throws IOException {
        TokenBuffer merged = new TokenBuffer(jp);
        merged.writeStartArray();
        merged.writeString(typeId);
        JsonParser p2 = this._tokens[index2].asParser(jp);
        p2.nextToken();
        merged.copyCurrentStructure(p2);
        merged.writeEndArray();
        p2 = merged.asParser(jp);
        p2.nextToken();
        return this._properties[index2].getProperty().deserialize(p2, ctxt);
    }

    protected final void _deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object bean, int index2, String typeId) throws IOException {
        TokenBuffer merged = new TokenBuffer(jp);
        merged.writeStartArray();
        merged.writeString(typeId);
        JsonParser p2 = this._tokens[index2].asParser(jp);
        p2.nextToken();
        merged.copyCurrentStructure(p2);
        merged.writeEndArray();
        p2 = merged.asParser(jp);
        p2.nextToken();
        this._properties[index2].getProperty().deserializeAndSet(p2, ctxt, bean);
    }

    private static final class ExtTypedProperty {
        private final SettableBeanProperty _property;
        private final TypeDeserializer _typeDeserializer;
        private final String _typePropertyName;

        public ExtTypedProperty(SettableBeanProperty property, TypeDeserializer typeDeser) {
            this._property = property;
            this._typeDeserializer = typeDeser;
            this._typePropertyName = typeDeser.getPropertyName();
        }

        public boolean hasTypePropertyName(String n) {
            return n.equals(this._typePropertyName);
        }

        public boolean hasDefaultType() {
            return this._typeDeserializer.getDefaultImpl() != null;
        }

        public String getDefaultTypeId() {
            Class<?> defaultType = this._typeDeserializer.getDefaultImpl();
            if (defaultType == null) {
                return null;
            }
            return this._typeDeserializer.getTypeIdResolver().idFromValueAndType(null, defaultType);
        }

        public String getTypePropertyName() {
            return this._typePropertyName;
        }

        public SettableBeanProperty getProperty() {
            return this._property;
        }
    }

    public static class Builder {
        private final ArrayList<ExtTypedProperty> _properties = new ArrayList();
        private final HashMap<String, Integer> _nameToPropertyIndex = new HashMap();

        public void addExternal(SettableBeanProperty property, TypeDeserializer typeDeser) {
            Integer index2 = this._properties.size();
            this._properties.add(new ExtTypedProperty(property, typeDeser));
            this._nameToPropertyIndex.put(property.getName(), index2);
            this._nameToPropertyIndex.put(typeDeser.getPropertyName(), index2);
        }

        public ExternalTypeHandler build() {
            return new ExternalTypeHandler(this._properties.toArray(new ExtTypedProperty[this._properties.size()]), this._nameToPropertyIndex, null, null);
        }
    }
}

