/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.LoggerFactory;

public class NonValidatingSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;

    public NonValidatingSSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new NonValidatingX509TrustManager()}, null);
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("while initializing an SSLContext", ExceptionUtils.getRootCause(ex));
        }
    }

    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    public Socket createSocket(Socket socket, String s2, int i, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s2, i, flag);
    }

    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.factory.createSocket(inaddr, i, inaddr1, j);
    }

    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.factory.createSocket(inaddr, i);
    }

    public Socket createSocket(String s2, int i, InetAddress inaddr, int j) throws IOException {
        return this.factory.createSocket(s2, i, inaddr, j);
    }

    public Socket createSocket(String s2, int i) throws IOException {
        return this.factory.createSocket(s2, i);
    }

    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    class NonValidatingX509TrustManager
    implements X509TrustManager {
        NonValidatingX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] cert, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] cert, String authType) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

