/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.ExtendedRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;

public class DefaultRetryPolicy
implements ExtendedRetryPolicy {
    public static final DefaultRetryPolicy INSTANCE = new DefaultRetryPolicy();

    private DefaultRetryPolicy() {
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        return receivedResponses >= requiredResponses && !dataRetrieved ? RetryPolicy.RetryDecision.retry(cl) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        return writeType == WriteType.BATCH_LOG ? RetryPolicy.RetryDecision.retry(cl) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        return nbRetry == 0 ? RetryPolicy.RetryDecision.tryNextHost(null) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, Exception e, int nbRetry) {
        return RetryPolicy.RetryDecision.tryNextHost(cl);
    }
}

