/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.utils.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

abstract class TypeCodec<T> {
    static final StringCodec utf8StringCodec = new StringCodec(Charset.forName("UTF-8"));
    static final StringCodec asciiStringCodec = new StringCodec(Charset.forName("US-ASCII"));
    static final LongCodec longCodec = new LongCodec();
    static final BytesCodec bytesCodec = new BytesCodec();
    static final BooleanCodec booleanCodec = new BooleanCodec();
    static final DecimalCodec decimalCodec = new DecimalCodec();
    static final DoubleCodec doubleCodec = new DoubleCodec();
    static final FloatCodec floatCodec = new FloatCodec();
    static final InetCodec inetCodec = new InetCodec();
    static final IntCodec intCodec = new IntCodec();
    static final DateCodec dateCodec = new DateCodec();
    static final UUIDCodec uuidCodec = new UUIDCodec();
    static final BigIntegerCodec bigIntegerCodec = new BigIntegerCodec();
    static final TimeUUIDCodec timeUuidCodec = new TimeUUIDCodec();
    private static final Map<DataType.Name, TypeCodec<?>> primitiveCodecs = new EnumMap(DataType.Name.class);

    private TypeCodec() {
    }

    public abstract T parse(String var1);

    public abstract String format(T var1);

    public abstract ByteBuffer serialize(T var1);

    public abstract T deserialize(ByteBuffer var1);

    static <T> TypeCodec<T> createFor(DataType.Name name) {
        assert (!name.isCollection());
        return primitiveCodecs.get((Object)name);
    }

    static <T> TypeCodec<List<T>> listOf(DataType arg, ProtocolVersion protocolVersion) {
        PrimitiveCollectionCodecs codecs = PrimitiveCollectionCodecs.forVersion(protocolVersion);
        ListCodec<Object> codec = codecs.primitiveListsCodecs.get((Object)arg.getName());
        return codec != null ? codec : new ListCodec<Object>(arg.codec(protocolVersion), protocolVersion);
    }

    static <T> TypeCodec<Set<T>> setOf(DataType arg, ProtocolVersion protocolVersion) {
        PrimitiveCollectionCodecs codecs = PrimitiveCollectionCodecs.forVersion(protocolVersion);
        SetCodec<Object> codec = codecs.primitiveSetsCodecs.get((Object)arg.getName());
        return codec != null ? codec : new SetCodec<Object>(arg.codec(protocolVersion), protocolVersion);
    }

    static <K, V> TypeCodec<Map<K, V>> mapOf(DataType keys, DataType values, ProtocolVersion protocolVersion) {
        PrimitiveCollectionCodecs codecs = PrimitiveCollectionCodecs.forVersion(protocolVersion);
        Map<DataType.Name, TypeCodec<Map<?, ?>>> valueCodecs = codecs.primitiveMapsCodecs.get((Object)keys.getName());
        MapCodec<Object, Object> codec = valueCodecs == null ? null : valueCodecs.get((Object)values.getName());
        return codec != null ? codec : new MapCodec<Object, Object>(keys.codec(protocolVersion), values.codec(protocolVersion), protocolVersion);
    }

    static UDTCodec udtOf(UserType definition) {
        return new UDTCodec(definition);
    }

    static TupleCodec tupleOf(TupleType type) {
        return new TupleCodec(type);
    }

    static DataType getDataTypeFor(Object value2) {
        if (value2 instanceof ByteBuffer) {
            return DataType.blob();
        }
        if (value2 instanceof Number) {
            if (value2 instanceof Integer) {
                return DataType.cint();
            }
            if (value2 instanceof Long) {
                return DataType.bigint();
            }
            if (value2 instanceof Float) {
                return DataType.cfloat();
            }
            if (value2 instanceof Double) {
                return DataType.cdouble();
            }
            if (value2 instanceof BigDecimal) {
                return DataType.decimal();
            }
            if (value2 instanceof BigInteger) {
                return DataType.varint();
            }
            throw new IllegalArgumentException("Type " + value2.getClass().getName() + " does not correspond to any CQL type");
        }
        if (value2 instanceof String) {
            return DataType.text();
        }
        if (value2 instanceof Boolean) {
            return DataType.cboolean();
        }
        if (value2 instanceof InetAddress) {
            return DataType.inet();
        }
        if (value2 instanceof Date) {
            return DataType.timestamp();
        }
        if (value2 instanceof UUID) {
            return DataType.uuid();
        }
        if (value2 instanceof List) {
            List l = (List)value2;
            if (l.isEmpty()) {
                return DataType.list(DataType.blob());
            }
            DataType eltType = TypeCodec.getDataTypeFor(l.get(0));
            return DataType.list(eltType);
        }
        if (value2 instanceof Set) {
            Set s2 = (Set)value2;
            if (s2.isEmpty()) {
                return DataType.set(DataType.blob());
            }
            DataType eltType = TypeCodec.getDataTypeFor(s2.iterator().next());
            return DataType.set(eltType);
        }
        if (value2 instanceof Map) {
            Map m = (Map)value2;
            if (m.isEmpty()) {
                return DataType.map(DataType.blob(), DataType.blob());
            }
            Map.Entry e = m.entrySet().iterator().next();
            return DataType.map(TypeCodec.getDataTypeFor(e.getKey()), TypeCodec.getDataTypeFor(e.getValue()));
        }
        if (value2 instanceof UDTValue) {
            return ((UDTValue)value2).getType();
        }
        if (value2 instanceof TupleValue) {
            return ((TupleValue)value2).getType();
        }
        throw new IllegalArgumentException("Type " + value2.getClass().getName() + " does not correspond to any CQL type");
    }

    private static ByteBuffer pack(List<ByteBuffer> buffers, int elements, ProtocolVersion version) {
        int size2 = 0;
        for (ByteBuffer bb : buffers) {
            int elemSize = TypeCodec.sizeOfValue(bb, version);
            size2 += elemSize;
        }
        ByteBuffer result2 = ByteBuffer.allocate(TypeCodec.sizeOfCollectionSize(elements, version) + size2);
        TypeCodec.writeCollectionSize(result2, elements, version);
        for (ByteBuffer bb : buffers) {
            TypeCodec.writeCollectionValue(result2, bb, version);
        }
        return (ByteBuffer)result2.flip();
    }

    private static void writeCollectionSize(ByteBuffer output, int elements, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                if (elements > 65535) {
                    throw new IllegalArgumentException("Native protocol version 2 supports up to 65535 elements in any collection - but collection contains " + elements + " elements");
                }
                output.putShort((short)elements);
                break;
            }
            case V3: {
                output.putInt(elements);
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
    }

    private static int getUnsignedShort(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    private static int readCollectionSize(ByteBuffer input2, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return TypeCodec.getUnsignedShort(input2);
            }
            case V3: {
                return input2.getInt();
            }
        }
        throw version.unsupported();
    }

    private static int sizeOfCollectionSize(int elements, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return 2;
            }
            case V3: {
                return 4;
            }
        }
        throw version.unsupported();
    }

    private static void writeCollectionValue(ByteBuffer output, ByteBuffer value2, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                assert (value2 != null);
                output.putShort((short)value2.remaining());
                output.put(value2.duplicate());
                break;
            }
            case V3: {
                if (value2 == null) {
                    output.putInt(-1);
                    break;
                }
                output.putInt(value2.remaining());
                output.put(value2.duplicate());
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
    }

    private static ByteBuffer readBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    private static ByteBuffer readCollectionValue(ByteBuffer input2, ProtocolVersion version) {
        int size2;
        switch (version) {
            case V1: 
            case V2: {
                size2 = TypeCodec.getUnsignedShort(input2);
                break;
            }
            case V3: {
                size2 = input2.getInt();
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
        return size2 < 0 ? null : TypeCodec.readBytes(input2, size2);
    }

    private static int sizeOfValue(ByteBuffer value2, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                int elemSize = value2.remaining();
                if (elemSize > 65535) {
                    throw new IllegalArgumentException("Native protocol version 2 supports only elements with size up to 65535 bytes - but element size is " + elemSize + " bytes");
                }
                return 2 + elemSize;
            }
            case V3: {
                return value2 == null ? 4 : 4 + value2.remaining();
            }
        }
        throw version.unsupported();
    }

    static {
        primitiveCodecs.put(DataType.Name.ASCII, asciiStringCodec);
        primitiveCodecs.put(DataType.Name.BIGINT, longCodec);
        primitiveCodecs.put(DataType.Name.BLOB, bytesCodec);
        primitiveCodecs.put(DataType.Name.BOOLEAN, booleanCodec);
        primitiveCodecs.put(DataType.Name.COUNTER, longCodec);
        primitiveCodecs.put(DataType.Name.DECIMAL, decimalCodec);
        primitiveCodecs.put(DataType.Name.DOUBLE, doubleCodec);
        primitiveCodecs.put(DataType.Name.FLOAT, floatCodec);
        primitiveCodecs.put(DataType.Name.INET, inetCodec);
        primitiveCodecs.put(DataType.Name.INT, intCodec);
        primitiveCodecs.put(DataType.Name.TEXT, utf8StringCodec);
        primitiveCodecs.put(DataType.Name.TIMESTAMP, dateCodec);
        primitiveCodecs.put(DataType.Name.UUID, uuidCodec);
        primitiveCodecs.put(DataType.Name.VARCHAR, utf8StringCodec);
        primitiveCodecs.put(DataType.Name.VARINT, bigIntegerCodec);
        primitiveCodecs.put(DataType.Name.TIMEUUID, timeUuidCodec);
        primitiveCodecs.put(DataType.Name.CUSTOM, bytesCodec);
    }

    static class TupleCodec
    extends TypeCodec<TupleValue> {
        private final TupleType type;

        public TupleCodec(TupleType type) {
            this.type = type;
        }

        @Override
        public TupleValue parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            TupleValue v = this.type.newValue();
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '(') {
                throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting '(' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == ')') {
                return v;
            }
            int i = 0;
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                DataType dt = this.type.getComponentTypes().get(i);
                v.setBytesUnsafe(i, dt.serialize(dt.parse(value2.substring(idx, n)), ProtocolVersion.V3));
                idx = n;
                ++i;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == ')') {
                    return v;
                }
                if (value2.charAt(idx) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                ++idx;
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed tuple value \"%s\", missing closing ')'", value2));
        }

        @Override
        public String format(TupleValue value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(TupleValue value2) {
            int size2 = 0;
            for (ByteBuffer v : value2.values) {
                size2 += 4 + (v == null ? 0 : v.remaining());
            }
            ByteBuffer result2 = ByteBuffer.allocate(size2);
            for (ByteBuffer bb : value2.values) {
                if (bb == null) {
                    result2.putInt(-1);
                    continue;
                }
                result2.putInt(bb.remaining());
                result2.put(bb.duplicate());
            }
            return (ByteBuffer)result2.flip();
        }

        @Override
        public TupleValue deserialize(ByteBuffer bytes) {
            ByteBuffer input2 = bytes.duplicate();
            TupleValue value2 = this.type.newValue();
            int i = 0;
            while (input2.hasRemaining() && i < value2.values.length) {
                int n = input2.getInt();
                value2.values[i++] = n < 0 ? null : TypeCodec.readBytes(input2, n);
            }
            return value2;
        }
    }

    static class UDTCodec
    extends TypeCodec<UDTValue> {
        private final UserType definition;

        public UDTCodec(UserType definition) {
            this.definition = definition;
        }

        @Override
        public UDTValue parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            return this.definition.parseValue(value2);
        }

        @Override
        public String format(UDTValue value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(UDTValue value2) {
            int size2 = 0;
            for (ByteBuffer v : value2.values) {
                size2 += 4 + (v == null ? 0 : v.remaining());
            }
            ByteBuffer result2 = ByteBuffer.allocate(size2);
            for (ByteBuffer bb : value2.values) {
                if (bb == null) {
                    result2.putInt(-1);
                    continue;
                }
                result2.putInt(bb.remaining());
                result2.put(bb.duplicate());
            }
            return (ByteBuffer)result2.flip();
        }

        @Override
        public UDTValue deserialize(ByteBuffer bytes) {
            ByteBuffer input2 = bytes.duplicate();
            UDTValue value2 = this.definition.newValue();
            int i = 0;
            while (input2.hasRemaining() && i < value2.values.length) {
                int n = input2.getInt();
                value2.values[i++] = n < 0 ? null : TypeCodec.readBytes(input2, n);
            }
            return value2;
        }
    }

    static class MapCodec<K, V>
    extends TypeCodec<Map<K, V>> {
        private final TypeCodec<K> keyCodec;
        private final TypeCodec<V> valueCodec;
        private final ProtocolVersion protocolVersion;

        public MapCodec(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec, ProtocolVersion protocolVersion) {
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
            this.protocolVersion = protocolVersion;
        }

        @Override
        public Map<K, V> parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '{') {
                throw new InvalidTypeException(String.format("cannot parse map value from \"%s\", at character %d expecting '{' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == '}') {
                return Collections.emptyMap();
            }
            HashMap<K, V> m = new HashMap<K, V>();
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                K k = this.keyCodec.parse(value2.substring(idx, n));
                idx = n;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx++) != ':') {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", at character %d expecting ':' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                V v = this.valueCodec.parse(value2.substring(idx, n));
                idx = n;
                m.put(k, v);
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == '}') {
                    return m;
                }
                if (value2.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed map value \"%s\", missing closing '}'", value2));
        }

        @Override
        public String format(Map<K, V> value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int i = 0;
            for (Map.Entry<K, V> e : value2.entrySet()) {
                if (i++ != 0) {
                    sb.append(", ");
                }
                sb.append(this.keyCodec.format(e.getKey()));
                sb.append(":");
                sb.append(this.valueCodec.format(e.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public ByteBuffer serialize(Map<K, V> value2) {
            ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(2 * value2.size());
            for (Map.Entry<K, V> entry2 : value2.entrySet()) {
                bbs.add(this.keyCodec.serialize(entry2.getKey()));
                bbs.add(this.valueCodec.serialize(entry2.getValue()));
            }
            return TypeCodec.pack(bbs, value2.size(), this.protocolVersion);
        }

        @Override
        public Map<K, V> deserialize(ByteBuffer bytes) {
            try {
                ByteBuffer input2 = bytes.duplicate();
                int n = TypeCodec.readCollectionSize(input2, this.protocolVersion);
                LinkedHashMap<K, V> m = new LinkedHashMap<K, V>(n);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer kbb = TypeCodec.readCollectionValue(input2, this.protocolVersion);
                    ByteBuffer vbb = TypeCodec.readCollectionValue(input2, this.protocolVersion);
                    m.put(this.keyCodec.deserialize(kbb), this.valueCodec.deserialize(vbb));
                }
                return m;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a map");
            }
        }
    }

    static class SetCodec<T>
    extends TypeCodec<Set<T>> {
        private final TypeCodec<T> eltCodec;
        private final ProtocolVersion protocolVersion;

        public SetCodec(TypeCodec<T> eltCodec, ProtocolVersion protocolVersion) {
            this.eltCodec = eltCodec;
            this.protocolVersion = protocolVersion;
        }

        @Override
        public Set<T> parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '{') {
                throw new InvalidTypeException(String.format("cannot parse set value from \"%s\", at character %d expecting '{' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == '}') {
                return Collections.emptySet();
            }
            HashSet<T> s2 = new HashSet<T>();
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse set value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                s2.add(this.eltCodec.parse(value2.substring(idx, n)));
                idx = n;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == '}') {
                    return s2;
                }
                if (value2.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse set value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed set value \"%s\", missing closing '}'", value2));
        }

        @Override
        public String format(Set<T> value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int i = 0;
            for (T v : value2) {
                if (i++ != 0) {
                    sb.append(", ");
                }
                sb.append(this.eltCodec.format(v));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public ByteBuffer serialize(Set<T> value2) {
            ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value2.size());
            for (T elt : value2) {
                bbs.add(this.eltCodec.serialize(elt));
            }
            return TypeCodec.pack(bbs, value2.size(), this.protocolVersion);
        }

        @Override
        public Set<T> deserialize(ByteBuffer bytes) {
            try {
                ByteBuffer input2 = bytes.duplicate();
                int n = TypeCodec.readCollectionSize(input2, this.protocolVersion);
                LinkedHashSet<T> l = new LinkedHashSet<T>(n);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer databb = TypeCodec.readCollectionValue(input2, this.protocolVersion);
                    l.add(this.eltCodec.deserialize(databb));
                }
                return l;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a set");
            }
        }
    }

    static class ListCodec<T>
    extends TypeCodec<List<T>> {
        private final TypeCodec<T> eltCodec;
        private final ProtocolVersion protocolVersion;

        public ListCodec(TypeCodec<T> eltCodec, ProtocolVersion protocolVersion) {
            this.eltCodec = eltCodec;
            this.protocolVersion = protocolVersion;
        }

        @Override
        public List<T> parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '[') {
                throw new InvalidTypeException(String.format("cannot parse list value from \"%s\", at character %d expecting '[' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == ']') {
                return Collections.emptyList();
            }
            ArrayList<T> l = new ArrayList<T>();
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse list value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                l.add(this.eltCodec.parse(value2.substring(idx, n)));
                idx = n;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == ']') {
                    return l;
                }
                if (value2.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse list value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed list value \"%s\", missing closing ']'", value2));
        }

        @Override
        public String format(List<T> value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < value2.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.eltCodec.format(value2.get(i)));
            }
            sb.append("]");
            return sb.toString();
        }

        @Override
        public ByteBuffer serialize(List<T> value2) {
            ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value2.size());
            for (T elt : value2) {
                bbs.add(this.eltCodec.serialize(elt));
            }
            return TypeCodec.pack(bbs, value2.size(), this.protocolVersion);
        }

        @Override
        public List<T> deserialize(ByteBuffer bytes) {
            try {
                ByteBuffer input2 = bytes.duplicate();
                int n = TypeCodec.readCollectionSize(input2, this.protocolVersion);
                ArrayList<T> l = new ArrayList<T>(n);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer databb = TypeCodec.readCollectionValue(input2, this.protocolVersion);
                    l.add(this.eltCodec.deserialize(databb));
                }
                return l;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize list");
            }
        }
    }

    static class BigIntegerCodec
    extends TypeCodec<BigInteger> {
        private BigIntegerCodec() {
        }

        @Override
        public BigInteger parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : new BigInteger(value2);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse varint value from \"%s\"", value2));
            }
        }

        @Override
        public String format(BigInteger value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(BigInteger value2) {
            return ByteBuffer.wrap(value2.toByteArray());
        }

        @Override
        public BigInteger deserialize(ByteBuffer bytes) {
            return new BigInteger(Bytes.getArray(bytes));
        }
    }

    static class TimeUUIDCodec
    extends UUIDCodec {
        private TimeUUIDCodec() {
        }

        @Override
        public UUID parse(String value2) {
            UUID id = super.parse(value2);
            if (id != null && id.version() != 1) {
                throw new InvalidTypeException(String.format("Cannot parse type 1 UUID value from \"%s\": represents a type %d UUID", value2, id.version()));
            }
            return id;
        }

        @Override
        public UUID deserialize(ByteBuffer bytes) {
            UUID id = super.deserialize(bytes);
            if (id.version() != 1) {
                throw new InvalidTypeException(String.format("Error deserializing type 1 UUID: deserialized value %s represents a type %d UUID", id, id.version()));
            }
            return id;
        }
    }

    static class UUIDCodec
    extends TypeCodec<UUID> {
        protected UUIDCodec() {
        }

        @Override
        public UUID parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : UUID.fromString(value2);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse UUID value from \"%s\"", value2));
            }
        }

        @Override
        public String format(UUID value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(UUID value2) {
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(0, value2.getMostSignificantBits());
            bb.putLong(8, value2.getLeastSignificantBits());
            return bb;
        }

        @Override
        public UUID deserialize(ByteBuffer bytes) {
            return new UUID(bytes.getLong(bytes.position() + 0), bytes.getLong(bytes.position() + 8));
        }
    }

    static class DateCodec
    extends TypeCodec<Date> {
        private static final String[] iso8601Patterns = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd", "yyyy-MM-ddZ"};
        private static final Pattern IS_LONG_PATTERN = Pattern.compile("^-?\\d+$");

        private DateCodec() {
        }

        private static Date parseDate(String str, String[] parsePatterns) throws ParseException {
            SimpleDateFormat parser = new SimpleDateFormat();
            parser.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            String[] stringArray = parsePatterns;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String parsePattern;
                String pattern = parsePattern = stringArray[i];
                parser.applyPattern(pattern);
                pos.setIndex(0);
                String str2 = str;
                Date date = parser.parse(str2, pos);
                if (date == null || pos.getIndex() != str2.length()) continue;
                return date;
            }
            throw new ParseException("Unable to parse the date: " + str, -1);
        }

        @Override
        public Date parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (ParseUtils.isQuoted(value2)) {
                value2 = ParseUtils.unquote(value2);
            }
            if (IS_LONG_PATTERN.matcher(value2).matches()) {
                try {
                    return new Date(Long.parseLong(value2));
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value2));
                }
            }
            try {
                return DateCodec.parseDate(value2, iso8601Patterns);
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Date value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Long.toString(value2.getTime());
        }

        @Override
        public ByteBuffer serialize(Date value2) {
            return longCodec.serializeNoBoxing(value2.getTime());
        }

        @Override
        public Date deserialize(ByteBuffer bytes) {
            return new Date(longCodec.deserializeNoBoxing(bytes));
        }
    }

    static class IntCodec
    extends TypeCodec<Integer> {
        private IntCodec() {
        }

        @Override
        public Integer parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Integer.valueOf(Integer.parseInt(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 32-bits int value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Integer value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Integer.toString(value2);
        }

        @Override
        public ByteBuffer serialize(Integer value2) {
            return this.serializeNoBoxing(value2);
        }

        public ByteBuffer serializeNoBoxing(int value2) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(0, value2);
            return bb;
        }

        @Override
        public Integer deserialize(ByteBuffer bytes) {
            return this.deserializeNoBoxing(bytes);
        }

        public int deserializeNoBoxing(ByteBuffer bytes) {
            if (bytes.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits integer value, expecting 4 bytes but got " + bytes.remaining());
            }
            return bytes.getInt(bytes.position());
        }
    }

    static class InetCodec
    extends TypeCodec<InetAddress> {
        private InetCodec() {
        }

        @Override
        public InetAddress parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value2 = value2.trim())) {
                throw new InvalidTypeException(String.format("inet values must be enclosed in single quotes (\"%s\")", value2));
            }
            try {
                return InetAddress.getByName(ParseUtils.unquote(value2));
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Cannot parse inet value from \"%s\"", value2));
            }
        }

        @Override
        public String format(InetAddress value2) {
            if (value2 == null) {
                return "NULL";
            }
            return "'" + value2.getHostAddress() + "'";
        }

        @Override
        public ByteBuffer serialize(InetAddress value2) {
            return ByteBuffer.wrap(value2.getAddress());
        }

        @Override
        public InetAddress deserialize(ByteBuffer bytes) {
            try {
                return InetAddress.getByAddress(Bytes.getArray(bytes));
            }
            catch (UnknownHostException e) {
                throw new InvalidTypeException("Invalid bytes for inet value, got " + bytes.remaining() + " bytes");
            }
        }
    }

    static class FloatCodec
    extends TypeCodec<Float> {
        private FloatCodec() {
        }

        @Override
        public Float parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Float.valueOf(Float.parseFloat(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 32-bits float value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Float value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Float.toString(value2.floatValue());
        }

        @Override
        public ByteBuffer serialize(Float value2) {
            return this.serializeNoBoxing(value2.floatValue());
        }

        public ByteBuffer serializeNoBoxing(float value2) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putFloat(0, value2);
            return bb;
        }

        @Override
        public Float deserialize(ByteBuffer bytes) {
            return Float.valueOf(this.deserializeNoBoxing(bytes));
        }

        public float deserializeNoBoxing(ByteBuffer bytes) {
            if (bytes.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits float value, expecting 4 bytes but got " + bytes.remaining());
            }
            return bytes.getFloat(bytes.position());
        }
    }

    static class DoubleCodec
    extends TypeCodec<Double> {
        private DoubleCodec() {
        }

        @Override
        public Double parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Double.valueOf(Double.parseDouble(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 64-bits double value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Double value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Double.toString(value2);
        }

        @Override
        public ByteBuffer serialize(Double value2) {
            return this.serializeNoBoxing(value2);
        }

        public ByteBuffer serializeNoBoxing(double value2) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putDouble(0, value2);
            return bb;
        }

        @Override
        public Double deserialize(ByteBuffer bytes) {
            return this.deserializeNoBoxing(bytes);
        }

        public double deserializeNoBoxing(ByteBuffer bytes) {
            if (bytes.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits double value, expecting 8 bytes but got " + bytes.remaining());
            }
            return bytes.getDouble(bytes.position());
        }
    }

    static class DecimalCodec
    extends TypeCodec<BigDecimal> {
        private DecimalCodec() {
        }

        @Override
        public BigDecimal parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : new BigDecimal(value2);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse decimal value from \"%s\"", value2));
            }
        }

        @Override
        public String format(BigDecimal value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(BigDecimal value2) {
            BigInteger bi = value2.unscaledValue();
            int scale = value2.scale();
            byte[] bibytes = bi.toByteArray();
            ByteBuffer bytes = ByteBuffer.allocate(4 + bibytes.length);
            bytes.putInt(scale);
            bytes.put(bibytes);
            bytes.rewind();
            return bytes;
        }

        @Override
        public BigDecimal deserialize(ByteBuffer bytes) {
            if (bytes.remaining() < 4) {
                throw new InvalidTypeException("Invalid decimal value, expecting at least 4 bytes but got " + bytes.remaining());
            }
            bytes = bytes.duplicate();
            int scale = bytes.getInt();
            byte[] bibytes = new byte[bytes.remaining()];
            bytes.get(bibytes);
            BigInteger bi = new BigInteger(bibytes);
            return new BigDecimal(bi, scale);
        }
    }

    static class BooleanCodec
    extends TypeCodec<Boolean> {
        private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
        private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});

        private BooleanCodec() {
        }

        @Override
        public Boolean parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (value2.equalsIgnoreCase(Boolean.FALSE.toString())) {
                return false;
            }
            if (value2.equalsIgnoreCase(Boolean.TRUE.toString())) {
                return true;
            }
            throw new InvalidTypeException(String.format("Cannot parse boolean value from \"%s\"", value2));
        }

        @Override
        public String format(Boolean value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2 != false ? "true" : "false";
        }

        @Override
        public ByteBuffer serialize(Boolean value2) {
            return this.serializeNoBoxing(value2);
        }

        public ByteBuffer serializeNoBoxing(boolean value2) {
            return value2 ? TRUE.duplicate() : FALSE.duplicate();
        }

        @Override
        public Boolean deserialize(ByteBuffer bytes) {
            return this.deserializeNoBoxing(bytes);
        }

        public boolean deserializeNoBoxing(ByteBuffer bytes) {
            if (bytes.remaining() != 1) {
                throw new InvalidTypeException("Invalid boolean value, expecting 1 byte but got " + bytes.remaining());
            }
            return bytes.get(bytes.position()) != 0;
        }
    }

    static class BytesCodec
    extends TypeCodec<ByteBuffer> {
        private BytesCodec() {
        }

        @Override
        public ByteBuffer parse(String value2) {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value2);
        }

        @Override
        public String format(ByteBuffer value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Bytes.toHexString(value2);
        }

        @Override
        public ByteBuffer serialize(ByteBuffer value2) {
            return value2.duplicate();
        }

        @Override
        public ByteBuffer deserialize(ByteBuffer bytes) {
            return bytes.duplicate();
        }
    }

    static class LongCodec
    extends TypeCodec<Long> {
        private LongCodec() {
        }

        @Override
        public Long parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Long.valueOf(Long.parseLong(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 64-bits long value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Long value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Long.toString(value2);
        }

        @Override
        public ByteBuffer serialize(Long value2) {
            return this.serializeNoBoxing(value2);
        }

        public ByteBuffer serializeNoBoxing(long value2) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(0, value2);
            return bb;
        }

        @Override
        public Long deserialize(ByteBuffer bytes) {
            return this.deserializeNoBoxing(bytes);
        }

        public long deserializeNoBoxing(ByteBuffer bytes) {
            if (bytes.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits long value, expecting 8 bytes but got " + bytes.remaining());
            }
            return bytes.getLong(bytes.position());
        }
    }

    static class StringCodec
    extends TypeCodec<String> {
        private final Charset charset;

        private StringCodec(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value2)) {
                throw new InvalidTypeException("text values must enclosed by a single quotes");
            }
            return ParseUtils.unquote(value2);
        }

        @Override
        public String format(String value2) {
            if (value2 == null) {
                return "NULL";
            }
            return ParseUtils.quote(value2);
        }

        @Override
        public ByteBuffer serialize(String value2) {
            return ByteBuffer.wrap(value2.getBytes(this.charset));
        }

        @Override
        public String deserialize(ByteBuffer bytes) {
            return new String(Bytes.getArray(bytes), this.charset);
        }
    }

    private static class PrimitiveCollectionCodecs {
        public final Map<DataType.Name, TypeCodec<List<?>>> primitiveListsCodecs = new EnumMap(DataType.Name.class);
        public final Map<DataType.Name, TypeCodec<Set<?>>> primitiveSetsCodecs = new EnumMap(DataType.Name.class);
        public final Map<DataType.Name, Map<DataType.Name, TypeCodec<Map<?, ?>>>> primitiveMapsCodecs = new EnumMap(DataType.Name.class);
        private static final PrimitiveCollectionCodecs primitiveCollectionCodecsV2 = new PrimitiveCollectionCodecs(ProtocolVersion.V2);
        private static final PrimitiveCollectionCodecs primitiveCollectionCodecsV3 = new PrimitiveCollectionCodecs(ProtocolVersion.V3);

        public PrimitiveCollectionCodecs(ProtocolVersion protocolVersion) {
            for (Map.Entry entry2 : primitiveCodecs.entrySet()) {
                DataType.Name type = (DataType.Name)((Object)entry2.getKey());
                TypeCodec codec = (TypeCodec)entry2.getValue();
                this.primitiveListsCodecs.put(type, new ListCodec(codec, protocolVersion));
                this.primitiveSetsCodecs.put(type, new SetCodec(codec, protocolVersion));
                EnumMap valueMap = new EnumMap(DataType.Name.class);
                for (Map.Entry valueEntry : primitiveCodecs.entrySet()) {
                    valueMap.put((DataType.Name)((Object)valueEntry.getKey()), new MapCodec(codec, (TypeCodec)valueEntry.getValue(), protocolVersion));
                }
                this.primitiveMapsCodecs.put(type, valueMap);
            }
        }

        static PrimitiveCollectionCodecs forVersion(ProtocolVersion version) {
            if (version == null) {
                version = ProtocolVersion.V1;
            }
            switch (version) {
                case V1: 
                case V2: {
                    return primitiveCollectionCodecsV2;
                }
                case V3: {
                    return primitiveCollectionCodecsV3;
                }
            }
            throw version.unsupported();
        }
    }
}

