/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

public class LexicalUtil {
    public static StringBuilder convertSpecialCharacters(StringBuilder inBuf) {
        int i = inBuf.indexOf("\\");
        if (i == -1) {
            return inBuf;
        }
        StringBuilder outBuf = new StringBuilder(inBuf.length());
        int last2 = -1;
        while (i != -1) {
            outBuf.append(inBuf.subSequence(last2 + 1, i));
            last2 = i + 1;
            char next2 = inBuf.charAt(last2);
            switch (next2) {
                case 'u': {
                    char unicodeChar = LexicalUtil.readUnicode(inBuf, last2 + 1);
                    outBuf.append(unicodeChar);
                    last2 += 4;
                    break;
                }
                case 'n': {
                    outBuf.append('\n');
                    break;
                }
                case 'r': {
                    outBuf.append('\r');
                    break;
                }
                case 't': {
                    outBuf.append('\t');
                    break;
                }
                case 'f': {
                    outBuf.append('\f');
                    break;
                }
                default: {
                    outBuf.append('\\');
                    outBuf.append(next2);
                }
            }
            i = inBuf.indexOf("\\", last2);
        }
        outBuf.append(inBuf.subSequence(last2 + 1, inBuf.length()));
        return outBuf;
    }

    private static char readUnicode(StringBuilder inBuf, int i) {
        int r = 0;
        for (int j = i; j < i + 4; ++j) {
            char atJ = inBuf.charAt(j);
            if (atJ >= '0' && atJ <= '9') {
                r = (r << 4) + atJ - 48;
                continue;
            }
            if (atJ >= 'A' && atJ <= 'F') {
                r = (r << 4) + atJ - 55;
                continue;
            }
            if (atJ < 'a' || atJ > 'f') continue;
            r = (r << 4) + atJ - 87;
        }
        return (char)r;
    }
}

