/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.http.service;

import eu.europeana.cloud.service.dps.storm.dao.HarvestedRecordsDAO;
import eu.europeana.cloud.service.dps.storm.incremental.CategorizationParameters;
import eu.europeana.cloud.service.dps.storm.service.HarvestedRecordCategorizationService;
import eu.europeana.cloud.service.dps.storm.utils.HarvestedRecord;

public class HttpTopologyCategorizationService
extends HarvestedRecordCategorizationService {
    public HttpTopologyCategorizationService(HarvestedRecordsDAO harvestedRecordsDAO) {
        super(harvestedRecordsDAO);
    }

    protected boolean isRecordEligibleForProcessing(HarvestedRecord harvestedRecord, CategorizationParameters categorizationParameters) {
        return categorizationParameters.isFullHarvest() || this.hashesMismatchForPreviewEnv(harvestedRecord, categorizationParameters) || this.hashesMismatchForPublishEnv(harvestedRecord, categorizationParameters);
    }

    private boolean hashesMismatchForPreviewEnv(HarvestedRecord harvestedRecord, CategorizationParameters categorizationParameters) {
        if (harvestedRecord.getPreviewHarvestMd5() != null) {
            return !categorizationParameters.getRecordMd5().equals(harvestedRecord.getPreviewHarvestMd5());
        }
        return true;
    }

    private boolean hashesMismatchForPublishEnv(HarvestedRecord harvestedRecord, CategorizationParameters categorizationParameters) {
        if (harvestedRecord.getPublishedHarvestMd5() != null) {
            return !categorizationParameters.getRecordMd5().equals(harvestedRecord.getPublishedHarvestMd5());
        }
        return true;
    }
}

