/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.http.spout;

import com.rits.cloning.Cloner;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.http.common.CompressionFileExtension;
import eu.europeana.cloud.http.common.UnpackingServiceFactory;
import eu.europeana.cloud.http.exceptions.CompressionExtensionNotRecognizedException;
import eu.europeana.cloud.http.service.FileUnpackingService;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import eu.europeana.cloud.service.dps.storm.NotificationTuple;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.spouts.kafka.CollectorWrapper;
import eu.europeana.cloud.service.dps.storm.spouts.kafka.CustomKafkaSpout;
import eu.europeana.cloud.service.dps.storm.spouts.kafka.TaskQueueFiller;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.EuropeanaIdCreator;
import eu.europeana.metis.transformation.service.EuropeanaIdException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.kafka.SpoutConfig;
import org.apache.storm.spout.ISpoutOutputCollector;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpKafkaSpout
extends CustomKafkaSpout {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpKafkaSpout.class);
    private static final int BATCH_MAX_SIZE = 4960;
    private static final String CLOUD_SEPARATOR = "_";
    private static final String MAC_TEMP_FOLDER = "__MACOSX";
    private static final String MAC_TEMP_FILE = ".DS_Store";
    private SpoutOutputCollector collector;
    TaskDownloader taskDownloader;

    HttpKafkaSpout(SpoutConfig spoutConf) {
        super(spoutConf);
        this.taskDownloader = new TaskDownloader();
    }

    public HttpKafkaSpout(SpoutConfig spoutConf, String hosts, int port, String keyspaceName, String userName, String password) {
        super(spoutConf, hosts, port, keyspaceName, userName, password);
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.taskDownloader = new TaskDownloader();
        this.collector = collector;
        super.open(conf, context, (SpoutOutputCollector)new CollectorWrapper((ISpoutOutputCollector)collector, (TaskQueueFiller)this.taskDownloader));
    }

    public void nextTuple() {
        block3: {
            StormTaskTuple stormTaskTuple = null;
            try {
                super.nextTuple();
                stormTaskTuple = this.taskDownloader.getTupleWithFileURL();
                if (stormTaskTuple != null) {
                    this.collector.emit((List)stormTaskTuple.toStormTuple());
                }
            }
            catch (Exception e) {
                LOGGER.error("Spout error: {}", (Object)e.getMessage());
                if (stormTaskTuple == null) break block3;
                this.cassandraTaskInfoDAO.dropTask(stormTaskTuple.getTaskId(), "The task was dropped because " + e.getMessage(), TaskState.DROPPED.toString());
            }
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(StormTaskTuple.getFields());
        declarer.declareStream("NotificationStream", NotificationTuple.getFields());
    }

    public void deactivate() {
        LOGGER.info("Deactivate method was executed");
        this.deactivateWaitingTasks();
        this.deactivateCurrentTask();
        LOGGER.info("Deactivate method was finished");
    }

    private void deactivateWaitingTasks() {
        DpsTask dpsTask;
        while ((dpsTask = this.taskDownloader.taskQueue.poll()) != null) {
            this.cassandraTaskInfoDAO.dropTask(dpsTask.getTaskId(), "The task was dropped because of redeployment", TaskState.DROPPED.toString());
        }
    }

    private void deactivateCurrentTask() {
        DpsTask currentDpsTask = this.taskDownloader.getCurrentDpsTask();
        if (currentDpsTask != null) {
            this.cassandraTaskInfoDAO.dropTask(currentDpsTask.getTaskId(), "The task was dropped because of redeployment", TaskState.DROPPED.toString());
        }
    }

    final class TaskDownloader
    extends Thread
    implements TaskQueueFiller {
        private static final int MAX_SIZE = 100;
        public static final String ERROR_WHILE_READING_A_FILE_MESSAGE = "Error while reading a file";
        ArrayBlockingQueue<DpsTask> taskQueue = new ArrayBlockingQueue(100);
        ArrayBlockingQueue<StormTaskTuple> tuplesWithFileUrls = new ArrayBlockingQueue(100);
        private DpsTask currentDpsTask;

        public TaskDownloader() {
            this.start();
        }

        public StormTaskTuple getTupleWithFileURL() {
            return this.tuplesWithFileUrls.poll();
        }

        public void addNewTask(DpsTask dpsTask) {
            try {
                this.taskQueue.put(dpsTask);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void run() {
            StormTaskTuple stormTaskTuple = null;
            while (true) {
                try {
                    while (true) {
                        this.currentDpsTask = this.taskQueue.take();
                        if (!taskStatusChecker.hasKillFlag(this.currentDpsTask.getTaskId())) {
                            this.startProgress(this.currentDpsTask.getTaskId());
                            stormTaskTuple = new StormTaskTuple(this.currentDpsTask.getTaskId(), this.currentDpsTask.getTaskName(), (String)this.currentDpsTask.getDataEntry(InputDataType.REPOSITORY_URLS).get(0), null, this.currentDpsTask.getParameters(), this.currentDpsTask.getOutputRevision(), new OAIPMHHarvestingDetails());
                            this.execute(stormTaskTuple);
                            continue;
                        }
                        LOGGER.info("Skipping DROPPED task {}", (Object)this.currentDpsTask.getTaskId());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("StaticDpsTaskSpout error: {}", (Object)e.getMessage());
                    if (stormTaskTuple == null) continue;
                    HttpKafkaSpout.this.cassandraTaskInfoDAO.dropTask(stormTaskTuple.getTaskId(), "The task was dropped because " + e.getMessage(), TaskState.DROPPED.toString());
                    continue;
                }
                break;
            }
        }

        private void startProgress(long taskId) {
            LOGGER.info("Start progressing for Task with id {}", (Object)this.currentDpsTask.getTaskId());
            HttpKafkaSpout.this.cassandraTaskInfoDAO.updateTask(taskId, "", String.valueOf(TaskState.CURRENTLY_PROCESSING), new Date());
        }

        private DpsTask getCurrentDpsTask() {
            return this.currentDpsTask;
        }

        private void emitErrorNotification(long taskId, String resource, String message, String additionalInformations) {
            NotificationTuple nt = NotificationTuple.prepareNotification((long)taskId, (String)resource, (RecordState)RecordState.ERROR, (String)message, (String)additionalInformations);
            HttpKafkaSpout.this.collector.emit("NotificationStream", (List)nt.toStormTuple());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void execute(StormTaskTuple stormTaskTuple) throws CompressionExtensionNotRecognizedException, IOException, InterruptedException {
            String metisDatasetId;
            boolean useDefaultIdentifiers;
            int expectedSize;
            File file;
            block3: {
                file = null;
                expectedSize = 0;
                try {
                    useDefaultIdentifiers = this.useDefaultIdentifier(stormTaskTuple);
                    metisDatasetId = null;
                    if (useDefaultIdentifiers || !StringUtils.isEmpty((String)(metisDatasetId = stormTaskTuple.getParameter("METIS_DATASET_ID")))) break block3;
                    HttpKafkaSpout.this.cassandraTaskInfoDAO.dropTask(stormTaskTuple.getTaskId(), "The task was dropped because METIS_DATASET_ID not provided", TaskState.DROPPED.toString());
                    this.removeTempFolder(file);
                    if (expectedSize != 0) return;
                }
                catch (Throwable throwable) {
                    this.removeTempFolder(file);
                    if (expectedSize != 0) throw throwable;
                    HttpKafkaSpout.this.cassandraTaskInfoDAO.dropTask(stormTaskTuple.getTaskId(), "The task was dropped because it is empty", TaskState.DROPPED.toString());
                    throw throwable;
                }
                HttpKafkaSpout.this.cassandraTaskInfoDAO.dropTask(stormTaskTuple.getTaskId(), "The task was dropped because it is empty", TaskState.DROPPED.toString());
                return;
            }
            String httpURL = stormTaskTuple.getFileUrl();
            file = this.downloadFile(httpURL);
            String compressingExtension = FilenameUtils.getExtension((String)file.getName());
            FileUnpackingService fileUnpackingService = UnpackingServiceFactory.createUnpackingService(compressingExtension);
            fileUnpackingService.unpackFile(file.getAbsolutePath(), file.getParent() + File.separator);
            Path start = Paths.get(new File(file.getParent()).toURI());
            expectedSize = this.iterateOverFiles(start, stormTaskTuple, useDefaultIdentifiers, metisDatasetId);
            HttpKafkaSpout.this.cassandraTaskInfoDAO.setUpdateExpectedSize(stormTaskTuple.getTaskId(), expectedSize);
            this.removeTempFolder(file);
            if (expectedSize != 0) return;
            HttpKafkaSpout.this.cassandraTaskInfoDAO.dropTask(stormTaskTuple.getTaskId(), "The task was dropped because it is empty", TaskState.DROPPED.toString());
        }

        /*
         * Exception decompiling
         */
        private File downloadFile(String httpURL) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private int iterateOverFiles(final Path start, final StormTaskTuple stormTaskTuple, final boolean useDefaultIdentifiers, final String metisDatasetId) throws IOException, InterruptedException {
            final AtomicInteger expectedSize = new AtomicInteger(0);
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (taskStatusChecker.hasKillFlag(stormTaskTuple.getTaskId())) {
                        return FileVisitResult.TERMINATE;
                    }
                    String fileName = TaskDownloader.this.getFileNameFromPath(file);
                    if (fileName.equals(HttpKafkaSpout.MAC_TEMP_FILE)) {
                        return FileVisitResult.CONTINUE;
                    }
                    String extension = FilenameUtils.getExtension((String)file.toString());
                    if (!CompressionFileExtension.contains(extension)) {
                        String mimeType = Files.probeContentType(file);
                        String filePath = file.toString();
                        String readableFileName = filePath.substring(start.toString().length() + 1).replaceAll("\\\\", "/");
                        try {
                            TaskDownloader.this.prepareTuple(stormTaskTuple, filePath, readableFileName, mimeType, useDefaultIdentifiers, metisDatasetId);
                        }
                        catch (EuropeanaIdException | IOException e) {
                            LOGGER.error(e.getMessage());
                            TaskDownloader.this.emitErrorNotification(stormTaskTuple.getTaskId(), readableFileName, TaskDownloader.ERROR_WHILE_READING_A_FILE_MESSAGE, "Error while reading a file: " + file.getFileName() + " because of " + e.getCause());
                        }
                        catch (InterruptedException e) {
                            LOGGER.error(e.getMessage());
                            TaskDownloader.this.emitErrorNotification(stormTaskTuple.getTaskId(), readableFileName, TaskDownloader.ERROR_WHILE_READING_A_FILE_MESSAGE, "Error while reading a file: " + file.getFileName() + " because of " + e.getCause());
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            expectedSize.set(expectedSize.incrementAndGet());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    String dirName = TaskDownloader.this.getFileNameFromPath(dir);
                    if (dirName.equals(HttpKafkaSpout.MAC_TEMP_FOLDER)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return expectedSize.get();
        }

        private String getFileNameFromPath(Path path) {
            if (path != null) {
                return path.getFileName().toString();
            }
            throw new IllegalArgumentException("Path parameter should never be null");
        }

        private void prepareTuple(StormTaskTuple stormTaskTuple, String filePath, String readableFilePath, String mimeType, boolean useDefaultIdentifiers, String datasetId) throws IOException, InterruptedException, EuropeanaIdException {
            try (FileInputStream fileInputStream = new FileInputStream(new File(filePath));){
                String localId;
                StormTaskTuple tuple = (StormTaskTuple)new Cloner().deepClone((Object)stormTaskTuple);
                tuple.setFileData((InputStream)fileInputStream);
                tuple.addParameter("OUTPUT_MIME_TYPE", mimeType);
                if (useDefaultIdentifiers) {
                    localId = this.formulateLocalId(readableFilePath);
                } else {
                    EuropeanaGeneratedIdsMap europeanaIdentifier = this.getEuropeanaIdentifier(tuple, datasetId);
                    localId = europeanaIdentifier.getEuropeanaGeneratedId();
                    tuple.addParameter("ADDITIONAL_LOCAL_IDENTIFIER", europeanaIdentifier.getSourceProvidedChoAbout());
                }
                tuple.addParameter("CLOUD_LOCAL_IDENTIFIER", localId);
                tuple.setFileUrl(readableFilePath);
                this.tuplesWithFileUrls.put(tuple);
            }
        }

        private boolean useDefaultIdentifier(StormTaskTuple stormTaskTuple) {
            boolean useDefaultIdentifiers = false;
            if ("true".equals(stormTaskTuple.getParameter("USE_DEFAULT_IDENTIFIERS"))) {
                useDefaultIdentifiers = true;
            }
            return useDefaultIdentifiers;
        }

        private EuropeanaGeneratedIdsMap getEuropeanaIdentifier(StormTaskTuple stormTaskTuple, String datasetId) throws EuropeanaIdException {
            String document = new String(stormTaskTuple.getFileData());
            EuropeanaIdCreator europeanIdCreator = new EuropeanaIdCreator();
            return europeanIdCreator.constructEuropeanaId(document, datasetId);
        }

        private String formulateLocalId(String readableFilePath) {
            return readableFilePath + HttpKafkaSpout.CLOUD_SEPARATOR + UUID.randomUUID().toString();
        }

        private void removeTempFolder(File file) {
            if (file != null) {
                try {
                    FileUtils.deleteDirectory((File)new File(file.getParent()));
                }
                catch (IOException e) {
                    LOGGER.error("ERROR while removing the temp Folder: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

