/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.http.service;

import eu.europeana.cloud.http.common.CompressionFileExtension;
import eu.europeana.cloud.http.common.UnpackingServiceFactory;
import eu.europeana.cloud.http.exceptions.CompressionExtensionNotRecognizedException;
import eu.europeana.cloud.http.service.FileUnpackingService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.zeroturnaround.zip.NameMapper;
import org.zeroturnaround.zip.ZipUtil;

public class ZipUnpackingService
implements FileUnpackingService {
    @Override
    public void unpackFile(String compressedFilePath, final String destinationFolder) throws CompressionExtensionNotRecognizedException, IOException {
        final ArrayList zipFiles = new ArrayList();
        ZipUtil.unpack((File)new File(compressedFilePath), (File)new File(destinationFolder), (NameMapper)new NameMapper(){

            public String map(String name) {
                if (CompressionFileExtension.contains(FilenameUtils.getExtension((String)name))) {
                    String compressedFilePath = destinationFolder + name;
                    zipFiles.add(compressedFilePath);
                }
                return name;
            }
        });
        for (String nestedCompressedFile : zipFiles) {
            String extension = FilenameUtils.getExtension((String)nestedCompressedFile);
            UnpackingServiceFactory.createUnpackingService(extension).unpackFile(nestedCompressedFile, FilenameUtils.removeExtension((String)nestedCompressedFile) + File.separator);
        }
    }
}

