/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.http.service;

import eu.europeana.cloud.http.common.CompressionFileExtension;
import eu.europeana.cloud.http.common.UnpackingServiceFactory;
import eu.europeana.cloud.http.exceptions.CompressionExtensionNotRecognizedException;
import eu.europeana.cloud.http.service.FileUnpackingService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.IOUtils;

public class GzUnpackingService
implements FileUnpackingService {
    public static final String TAR = ".tar";

    @Override
    public void unpackFile(String zipFile, String destinationFolder) throws CompressionExtensionNotRecognizedException, IOException {
        String[] extensions = CompressionFileExtension.getExtensionValues();
        this.unpackFile(zipFile, destinationFolder, extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unpackFile(String compressedFile, String destinationFolder, String[] extensions) throws CompressionExtensionNotRecognizedException, IOException {
        File destination = new File(destinationFolder);
        if (FilenameUtils.getName((String)compressedFile).contains(TAR) || FilenameUtils.getExtension((String)compressedFile).equals(CompressionFileExtension.TGZIP.getExtension())) {
            File newDestination = this.extractTarGzipArchive(compressedFile, destination);
            Iterator files = FileUtils.iterateFiles((File)newDestination, (String[])extensions, (boolean)true);
            while (files.hasNext()) {
                File file = (File)files.next();
                String extension = FilenameUtils.getExtension((String)file.getName());
                UnpackingServiceFactory.createUnpackingService(extension).unpackFile(file.getAbsolutePath(), file.getParent() + File.separator);
            }
            return;
        }
        GzipCompressorInputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = new GzipCompressorInputStream((InputStream)new FileInputStream(compressedFile));
            fileOutputStream = new FileOutputStream(new File(FilenameUtils.removeExtension((String)compressedFile)));
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        IOUtils.closeQuietly((Closeable)fileOutputStream);
    }

    private File extractTarGzipArchive(String compressedFile, File destination) throws IOException {
        File archive = new File(compressedFile);
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.GZIP);
        archiver.extract(archive, destination);
        String fileName = this.getFileName(compressedFile);
        return this.getDestinationFolder(destination.getPath(), fileName);
    }

    private String getFileName(String fileLocation) {
        return FilenameUtils.getName((String)FilenameUtils.removeExtension((String)FilenameUtils.removeExtension((String)fileLocation)));
    }

    private File getDestinationFolder(String destination, String fileName) {
        return new File(destination + File.separator + fileName);
    }
}

