/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip.commons;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.zeroturnaround.zip.commons.StringBuilderWriter;

public class IOUtils {
    private static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(InputStream input2) {
        IOUtils.closeQuietly((Closeable)input2);
    }

    public static void closeQuietly(OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, output);
        return output.toByteArray();
    }

    public static String toString(InputStream input2, String encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input2, sw, encoding);
        return sw.toString();
    }

    public static int copy(InputStream input2, OutputStream output) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(InputStream input2, OutputStream output) throws IOException {
        return IOUtils.copyLarge(input2, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input2, OutputStream output, byte[] buffer) throws IOException {
        long count2 = 0L;
        int n = 0;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static void copy(InputStream input2, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input2);
        IOUtils.copy(in, output);
    }

    public static void copy(InputStream input2, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input2, output);
        } else {
            InputStreamReader in = new InputStreamReader(input2, encoding);
            IOUtils.copy(in, output);
        }
    }

    public static int copy(Reader input2, Writer output) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader input2, Writer output) throws IOException {
        return IOUtils.copyLarge(input2, output, new char[4096]);
    }

    public static long copyLarge(Reader input2, Writer output, char[] buffer) throws IOException {
        long count2 = 0L;
        int n = 0;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    static {
        StringBuilderWriter buf = new StringBuilderWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
        out.close();
    }
}

